/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.scheduledTasks.PeriodUnit;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskCategoryDAO;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.plusmpm.util.scheduledTasks.AbstractPeriodicTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.plusmpm.util.scheduledTasks.exception.TaskNotExecutingException;
import com.suncode.pwfl.administration.scheduledtask.email.ScheduledTaskEmailNotification;
import com.suncode.pwfl.administration.scheduledtask.info.ScheduledTaskInfoService;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskNotFoundException;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskStartException;
import com.suncode.pwfl.administration.scheduledtask.info.execution.ScheduledTaskExecution;
import com.suncode.pwfl.administration.scheduledtask.service.PeriodicTaskResolver;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.form.stereotype.Setter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskAuditParameter;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskDtoHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskDto;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskSearchDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduledtasks"})
public class ScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskController.class);
    @Autowired
    private ScheduledTaskDtoHelper scheduledTaskDtoHelper;
    @Autowired
    private ScheduledTaskService scheduledTaskService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private PeriodicTaskResolver periodicTaskResolver;
    @Autowired
    private TomcatService tomcatService;
    @Autowired
    private TransactionWrapper transactionWrapper;
    @Autowired
    private ScheduledTaskInfoService scheduledTaskInfoService;
    @Autowired
    private ScheduledTaskHelper scheduledTaskHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<CountedResult<ScheduledTaskDto>> getScheduledTasks(ScheduledTaskSearchDto searchDto) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            CountedResult resultDto = (CountedResult)this.transactionWrapper.doInHibernateTransaction(session -> this.getScheduledTasks(session, searchDto));
            log.info("Znalezionych zada\u0144: " + resultDto.getTotal());
            return new ResponseEntity((Object)resultDto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private CountedResult<ScheduledTaskDto> getScheduledTasks(Session session, ScheduledTaskSearchDto searchDto) {
        Long total;
        List tasks;
        boolean isDeprecatedCategory = "deprecated".equalsIgnoreCase(searchDto.getCategory());
        log.info("Pobieranie wszystkich zada\u0144 z kategorii id: " + searchDto.getCategory());
        Order order = this.getOrder(searchDto.getPropertyName(), searchDto.getDirection());
        if ("all".equalsIgnoreCase(searchDto.getCategory())) {
            tasks = ScheduledTasksTableDAO.getWithParameters((Session)session, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing(), (Order)order, (Integer)searchDto.getStart(), (Integer)searchDto.getLimit());
            total = ScheduledTasksTableDAO.countTask((Session)session, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing());
        } else if (isDeprecatedCategory) {
            tasks = ScheduledTasksTableDAO.getWithParameters((Session)session, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing(), (Order)order, null, null).stream().filter(arg_0 -> ((ScheduledTaskService)this.scheduledTaskService).isScheduledTaskDeprecated(arg_0)).collect(Collectors.toList());
            total = tasks.size();
        } else {
            Long categoryId = StringUtils.isNotBlank((CharSequence)searchDto.getCategory()) ? Long.valueOf(searchDto.getCategory()) : null;
            tasks = ScheduledTaskCategoryDAO.getTasksWithParameters((Session)session, (Long)categoryId, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing(), (Order)order, (Integer)searchDto.getStart(), (Integer)searchDto.getLimit());
            total = ScheduledTaskCategoryDAO.countTaskWithParametr((Session)session, (Long)categoryId, (String)searchDto.getQuery(), (Boolean)searchDto.getActive(), (Boolean)searchDto.getProcessing());
        }
        List result = tasks.stream().map(this.scheduledTaskDtoHelper::entityToDto).collect(Collectors.toList());
        return isDeprecatedCategory ? Paginator.forAll(result).viewPageByOffset(searchDto.getStart(), searchDto.getLimit()) : new CountedResult(total.longValue(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"active"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> changeActiveStatus(@RequestBody ChangeActiveStatusDto changeActiveDto) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        long id = changeActiveDto.getId();
        boolean active = changeActiveDto.isActive();
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName()).params(new AuditParamsBuilder().param("id", (Object)id).param("property", (Object)"active").param("value", (Object)active).build());
        try {
            if (active) {
                AbstractPeriodicTask periodicTask = (AbstractPeriodicTask)this.transactionWrapper.doInHibernateTransaction(session -> {
                    ScheduledTasksTable task = ScheduledTasksTableDAO.get((Session)session, (Long)id);
                    task.setIs_active(Boolean.valueOf(true));
                    return this.periodicTaskResolver.getInstance(task);
                });
                ScheduledTasksManager.getInstance().getScheduler().schedule(periodicTask);
            } else {
                this.transactionWrapper.doInHibernateTransaction(session -> {
                    ScheduledTasksTable task = ScheduledTasksTableDAO.get((Session)session, (Long)id);
                    task.setIs_active(Boolean.valueOf(false));
                });
                ScheduledTasksManager.getInstance().getScheduler().delete(Long.valueOf(id));
            }
            auditBuilder.success(true);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((Object)ImmutableMap.of((Object)"success", (Object)false), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            auditBuilder.build().log();
        }
        return new ResponseEntity((Object)ImmutableMap.of((Object)"success", (Object)true), (HttpStatusCode)HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"{id}/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<ExecuteTaskDto> execute(@PathVariable Long id, @RequestParam(required=false, defaultValue="NONE") AwaitScheduledTaskPhase awaitPhase, @RequestParam(required=false) Long timeoutSeconds) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName()).params(new AuditParamsBuilder().param("id", (Object)id).build()).success(false);
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            ExecuteTaskDto.ExecuteTaskDtoBuilder executeTaskDtoBuilder = ExecuteTaskDto.builder().message("OK").timeoutExceeded(false);
            if (awaitPhase != AwaitScheduledTaskPhase.NONE && (timeoutSeconds == null || timeoutSeconds < 0L)) {
                ResponseEntity responseEntity = new ResponseEntity((Object)executeTaskDtoBuilder.message("A positive timeoutSeconds parameter must be provided for scheduled task phase awaiting").build(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
                return responseEntity;
            }
            ScheduledTaskExecution execution = this.scheduledTaskInfoService.executeTaskManually(id.longValue());
            switch (awaitPhase) {
                case START: {
                    boolean timeoutExceeded = !execution.awaitTaskStarted(Duration.ofSeconds(timeoutSeconds));
                    executeTaskDtoBuilder.timeoutExceeded(timeoutExceeded);
                    break;
                }
                case COMPLETION: {
                    boolean timeoutExceeded = !execution.awaitTaskCompleted(Duration.ofSeconds(timeoutSeconds));
                    executeTaskDtoBuilder.timeoutExceeded(timeoutExceeded);
                }
            }
            auditBuilder.success(true);
            ResponseEntity responseEntity = new ResponseEntity((Object)executeTaskDtoBuilder.build(), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (ScheduledTaskNotFoundException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((Object)ExecuteTaskDto.builder().message(e.getMessage()).timeoutExceeded(false).build(), (HttpStatusCode)HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (ScheduledTaskStartException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((Object)ExecuteTaskDto.builder().message(e.getMessage()).timeoutExceeded(false).build(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            if (auditBuilder != null) {
                auditBuilder.build().log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"invoke"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> invokeScheduledTaskAction(@RequestParam String action, @RequestParam Long id) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        ManualAuditBuilder auditBuilder = null;
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            switch (action) {
                case "cancel": {
                    auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_STOP_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName()).params(new AuditParamsBuilder().param("id", (Object)id).build());
                    boolean success = ScheduledTasksManager.getInstance().getExecutor().cancelTask((Object)id);
                    result.put("success", Boolean.valueOf(success));
                    auditBuilder.success(true);
                    break;
                }
                case "execute": {
                    auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName()).params(new AuditParamsBuilder().param("id", (Object)id).build()).success(false);
                    boolean success = ScheduledTasksManager.getInstance().getExecutor().executeTask(id, 5L, TimeUnit.SECONDS);
                    if (success) {
                        Double progress = ScheduledTasksManager.getInstance().getExecutor().getTaskProgress((Object)id);
                        result.put("progress", progress);
                        auditBuilder.success(true);
                    }
                    result.put("success", Boolean.valueOf(success));
                    break;
                }
                case "remove": {
                    auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName()).params(new AuditParamsBuilder().param("id", (Object)id).build()).success(false);
                    if (!ScheduledTasksManager.getInstance().getExecutor().isTaskRunning((Object)id).booleanValue()) {
                        ManualAuditBuilder finalAuditBuilder = auditBuilder;
                        this.transactionWrapper.doInHibernateTransaction(session -> {
                            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            ScheduledTasksTable task = ScheduledTasksTableDAO.getWithParameters((Session)session, (Long)id);
                            PeriodUnit periodUnit = task.getPeriodUnit();
                            String serializedAuditParameters = task.getScheduled_tasks_parameters().stream().map(paramEntity -> ScheduledTaskAuditParameter.from(paramEntity, this.scheduledTaskHelper)).map(ScheduledTaskAuditParameter::toString).collect(Collectors.joining("\n"));
                            AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id).param("staticId", (Object)task.getStaticId()).param("name", (Object)task.getName()).param("description", (Object)task.getDescription()).param("nextRun", Optional.ofNullable(task.getNext_run()).map(dateFormatter::format).orElse(null)).param("runOnce", (Object)task.getRun_once()).param("periodValue", (Object)task.getPeriodValue()).param("periodUnit", (Object)(periodUnit != null ? periodUnit.getAuditKey() : null)).param("active", (Object)task.getIs_active()).param("savehistory", (Object)task.getSaveHistory()).param("startingHour", task.getStartingHour() != null ? task.getStartingHour() : "").param("endingHour", task.getEndingHour() != null ? task.getEndingHour() : "").param("maxWorkingMinutes", task.getMaxWorkingMinutes() != null ? task.getMaxWorkingMinutes() : "").param("userNameNotifications", (Object)ListUtils.emptyIfNull((List)task.getUserNotifications()).stream().map(userNotif -> userNotif.getUser().getUserName()).collect(Collectors.joining(", "))).param("emailNotifications", (Object)ListUtils.emptyIfNull((List)task.getEmailNotifications()).stream().map(ScheduledTaskEmailNotification::getEmail).collect(Collectors.joining(", "))).param("parameters", (Object)serializedAuditParameters);
                            finalAuditBuilder.params(auditParamsBuilder.build());
                            this.scheduledTaskService.deleteScheduledTask(id);
                        });
                        result.put("success", Boolean.valueOf(true));
                        auditBuilder.success(true);
                        break;
                    }
                    result.put("success", Boolean.valueOf(false));
                    break;
                }
                case "awaitcompletion": {
                    boolean success = ScheduledTasksManager.getInstance().getExecutor().awaitCompletion(id, 28L, TimeUnit.SECONDS);
                    result.put("success", Boolean.valueOf(success));
                    break;
                }
                default: {
                    log.warn("Nieznana akcja: " + action);
                    ResponseEntity responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
                    return responseEntity;
                }
            }
            String string = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return string;
        }
        catch (TaskNotExecutingException e) {
            log.info("Zadanie nie jest aktualnie wykonywane.");
            result.put("success", Boolean.valueOf(false));
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            ResponseEntity responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            if (auditBuilder != null) {
                auditBuilder.build().log();
            }
        }
    }

    @RequestMapping(value={"notifications/users"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<UserDto> getUsersForNotifications(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        CountedResult users = this.scheduledTaskService.findUsersByQuery(query, start, limit);
        return new CountedResult(users.getTotal(), users.getData().stream().map(user -> new UserDto(user.getUserName(), this.getDisplayName((User)user))).collect(Collectors.toList()));
    }

    private String getDisplayName(User user) {
        if (StringUtils.isNotBlank((CharSequence)user.getFullName())) {
            return user.getFullName() + " (" + user.getUserName() + ")";
        }
        return user.getUserName();
    }

    private Order getOrder(String propertyName, String direction) {
        String field = StringUtils.isBlank((CharSequence)propertyName) ? "name" : propertyName;
        switch (propertyName) {
            case "lastRun": {
                field = "last_run";
                break;
            }
            case "className": {
                field = "class_name";
                break;
            }
            case "methodName": {
                field = "method_name";
            }
        }
        if (Objects.equals(direction, "DESC")) {
            return Order.desc((String)field);
        }
        return Order.asc((String)field);
    }

    @Setter
    public static class ChangeActiveStatusDto {
        private long id;
        private boolean active;

        public long getId() {
            return this.id;
        }

        public boolean isActive() {
            return this.active;
        }

        public ChangeActiveStatusDto() {
        }

        @ConstructorProperties(value={"id", "active"})
        public ChangeActiveStatusDto(long id, boolean active) {
            this.id = id;
            this.active = active;
        }
    }

    public static class ExecuteTaskDto {
        private String message;
        private boolean timeoutExceeded;

        public static ExecuteTaskDtoBuilder builder() {
            return new ExecuteTaskDtoBuilder();
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isTimeoutExceeded() {
            return this.timeoutExceeded;
        }

        @ConstructorProperties(value={"message", "timeoutExceeded"})
        public ExecuteTaskDto(String message, boolean timeoutExceeded) {
            this.message = message;
            this.timeoutExceeded = timeoutExceeded;
        }

        public static class ExecuteTaskDtoBuilder {
            private String message;
            private boolean timeoutExceeded;

            ExecuteTaskDtoBuilder() {
            }

            public ExecuteTaskDtoBuilder message(String message) {
                this.message = message;
                return this;
            }

            public ExecuteTaskDtoBuilder timeoutExceeded(boolean timeoutExceeded) {
                this.timeoutExceeded = timeoutExceeded;
                return this;
            }

            public ExecuteTaskDto build() {
                return new ExecuteTaskDto(this.message, this.timeoutExceeded);
            }

            public String toString() {
                return "ScheduledTaskController.ExecuteTaskDto.ExecuteTaskDtoBuilder(message=" + this.message + ", timeoutExceeded=" + this.timeoutExceeded + ")";
            }
        }
    }

    public static enum AwaitScheduledTaskPhase {
        NONE,
        START,
        COMPLETION;

    }

    public static class UserDto {
        private final String userName;
        private final String displayName;

        @ConstructorProperties(value={"userName", "displayName"})
        public UserDto(String userName, String displayName) {
            this.userName = userName;
            this.displayName = displayName;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDto)) {
                return false;
            }
            UserDto other = (UserDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "ScheduledTaskController.UserDto(userName=" + this.getUserName() + ", displayName=" + this.getDisplayName() + ")";
        }
    }
}

