/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.resource.group.CalendarResourceGroup;
import com.suncode.pwfl.calendar.resource.group.CalendarResourceGroupService;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/resource/group"})
@Api(hidden=true)
public class CalendarResourceGroupController {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceGroupController.class);
    private final CalendarResourceGroupService calendarResourceGroupService;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping
    public List<CalendarResourceGroup> getCalendarResourceGroups() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.calendarResourceGroupService.getCalendarResourceGroups();
    }

    @GetMapping(value={"/{id}"})
    public CalendarResourceGroup getCalendarResourceGroup(@PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.calendarResourceGroupService.getCalendarResourceGroup(id);
    }

    @GetMapping(value={"/user"})
    public List<CalendarResourceGroup> getCalendarResourceGroupsSeenByUser() {
        String username = UserContext.current().getUser().getUserName();
        return this.calendarResourceGroupService.getCalendarResourceGroupsSeenByUser(username);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarResourceGroup createCalendarResourceGroup(@RequestBody CalendarResourceGroup calendarResourceGroup, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().params(this.paramsFromCalendarResourceGroup(calendarResourceGroup));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE_GROUP).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            CalendarResourceGroup createdCalendarResourceGroup = this.calendarResourceGroupService.createCalendarResourceGroup(calendarResourceGroup);
            auditParamsBuilder.param("id", (Object)createdCalendarResourceGroup.getId()).params(this.paramsFromCalendarResourceGroup(createdCalendarResourceGroup));
            auditBuilder.params(auditParamsBuilder.build());
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return createdCalendarResourceGroup;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"/{id}"})
    public CalendarResourceGroup updateCalendarResourceGroup(@PathVariable Long id, @RequestBody CalendarResourceGroup calendarResourceGroup, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id).params(this.paramsFromCalendarResourceGroup(calendarResourceGroup));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_CALENDAR_RESOURCE_GROUP).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            CalendarResourceGroup oldCalendarResourceGroup = this.calendarResourceGroupService.getCalendarResourceGroup(id);
            CalendarResourceGroup updatedCalendarResourceGroup = this.calendarResourceGroupService.updateCalendarResourceGroup(id, calendarResourceGroup);
            auditParamsBuilder.params(this.paramsFromCalendarResourceGroup(oldCalendarResourceGroup, updatedCalendarResourceGroup));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return updatedCalendarResourceGroup;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"/{id}"})
    public RestResult deleteCalendarResourceGroup(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_GROUP).params(new AuditParamsBuilder().param("id", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.calendarResourceGroupService.deleteCalendarResourceGroup(id);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    private Map<String, Object> paramsFromCalendarResourceGroup(CalendarResourceGroup calendarResourceGroup) {
        return new AuditParamsBuilder().param("name", (Object)calendarResourceGroup.getName()).param("description", (Object)calendarResourceGroup.getDescription()).param("parentResourceGroupId", (Object)calendarResourceGroup.getParentResourceGroupId()).build();
    }

    private Map<String, Object> paramsFromCalendarResourceGroup(CalendarResourceGroup oldCalendarResourceGroup, CalendarResourceGroup newCalendarResourceGroup) {
        return new AuditParamsBuilder().param("name", (Object)oldCalendarResourceGroup.getName(), (Object)newCalendarResourceGroup.getName()).param("description", (Object)oldCalendarResourceGroup.getDescription(), (Object)newCalendarResourceGroup.getDescription()).param("parentResourceGroupId", (Object)oldCalendarResourceGroup.getParentResourceGroupId(), (Object)newCalendarResourceGroup.getParentResourceGroupId()).build();
    }

    @ConstructorProperties(value={"calendarResourceGroupService", "authorizationHelper"})
    @Autowired
    public CalendarResourceGroupController(CalendarResourceGroupService calendarResourceGroupService, AuthorizationHelper authorizationHelper) {
        this.calendarResourceGroupService = calendarResourceGroupService;
        this.authorizationHelper = authorizationHelper;
    }
}

