/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.calendar.Period;
import com.suncode.pwfl.calendar.api.CalendarFacade;
import com.suncode.pwfl.calendar.event.Event;
import com.suncode.pwfl.calendar.support.HolidaysCache;
import com.suncode.pwfl.web.dto.calendar.CalendarDto;
import com.suncode.pwfl.web.dto.calendar.event.EventDto;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar"})
@Api(hidden=true)
public class CalendarController {
    private final CalendarFacade calendarFacade;
    private final UserService userService;
    private final CalendarMapper calendarMapper;
    private final HolidaysCache holidaysCache;

    @GetMapping
    public List<CalendarDto> getCalendarsForUser() {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        return this.calendarFacade.getCalendars(user).stream().map(this.calendarMapper::toCalendarDto).toList();
    }

    @GetMapping(value={"resource/{resourceId}/events"})
    public List<EventDto> getEventsForResourceByInterval(@PathVariable Long resourceId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        return this.calendarFacade.getEventsForResourceByPeriod(resourceId, user, new Period(false, fromDateTime, toDateTime)).stream().map(event -> this.calendarMapper.toEventDto((Event)event, user)).toList();
    }

    @GetMapping(value={"holidays"})
    public Set<String> getHolidaysForYear(@RequestParam int year) {
        return this.holidaysCache.getHolidaysForYear(year).stream().map(holiday -> holiday.format(DateTimeFormatter.ISO_DATE)).collect(Collectors.toSet());
    }

    @ConstructorProperties(value={"calendarFacade", "userService", "calendarMapper", "holidaysCache"})
    @Autowired
    public CalendarController(CalendarFacade calendarFacade, UserService userService, CalendarMapper calendarMapper, HolidaysCache holidaysCache) {
        this.calendarFacade = calendarFacade;
        this.userService = userService;
        this.calendarMapper = calendarMapper;
        this.holidaysCache = holidaysCache;
    }
}

