/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.authentication.oauth2.googleApi;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthentication;
import com.suncode.pwfl.administration.authentication.googleApi.GoogleApiAuthenticationService;
import com.suncode.pwfl.administration.system.SystemPropertiesHelper;
import com.suncode.pwfl.google.drive.GoogleDriveApiClient;
import com.suncode.pwfl.google.drive.GoogleDriveInternalService;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Api(hidden=true)
@RestController
@RequestMapping(value={"googleOauth2"})
public class OAuth2GoogleApiController {
    private static final Logger log = LoggerFactory.getLogger(OAuth2GoogleApiController.class);
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final List<String> SCOPES = Collections.singletonList("https://www.googleapis.com/auth/drive");
    private final GoogleDriveApiClient googleDriveApiClient;
    private final GoogleDriveInternalService googleDriveInternalService;
    private final SystemPropertiesHelper systemPropertiesHelper;
    private final GoogleApiAuthenticationService googleApiAuthenticationService;

    @GetMapping(value={"/callback"})
    public RedirectView callback(@RequestParam(required=false) String code, @RequestParam(required=false) String error, @CookieValue(value="google_api_auth_id", required=false) String googleApiAuthId) throws Exception {
        GoogleApiAuthentication configuration;
        UriComponentsBuilder redirectUriBuilder = ServletUriComponentsBuilder.fromCurrentContextPath().path("/Admin.do").queryParam("tab", new Object[]{"configuration"}).queryParam("googleAuthId", new Object[]{googleApiAuthId}).fragment("authenticationManagement");
        if (error != null) {
            log.error("B\u0142\u0105d po\u0142\u0105czenia z Google Api o id: " + googleApiAuthId + ". Error: " + error);
            redirectUriBuilder.queryParam("error", new Object[]{"polaczenie_nieudane"});
            redirectUriBuilder.queryParam("errorMsg", new Object[]{error});
        }
        if ((configuration = (GoogleApiAuthentication)this.googleApiAuthenticationService.get((Serializable)((Object)googleApiAuthId))) != null) {
            try {
                GoogleClientSecrets clientSecrets = this.googleDriveApiClient.getOauthClintSecrets(configuration);
                String oauthRedirectUri = this.systemPropertiesHelper.prepareHttpLinkParameter() + "/api/googleOauth2/callback";
                GoogleTokenResponse tokenResponse = new GoogleAuthorizationCodeTokenRequest((HttpTransport)new NetHttpTransport(), JSON_FACTORY, clientSecrets.getDetails().getClientId(), clientSecrets.getDetails().getClientSecret(), code, oauthRedirectUri).execute();
                String refreshToken = tokenResponse.getRefreshToken();
                GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)new NetHttpTransport(), JSON_FACTORY, clientSecrets, SCOPES).setAccessType("offline").build();
                Credential credential = flow.createAndStoreCredential((TokenResponse)tokenResponse, "user");
                credential.setRefreshToken(refreshToken);
                this.googleDriveApiClient.initDriveApiClient(credential, configuration);
                this.googleApiAuthenticationService.saveRefreshToken(refreshToken, googleApiAuthId);
                log.info("Prawid\u0142owe po\u0142\u0105czenie z Google Api za pomoc\u0105 konfiguracji o id: " + googleApiAuthId);
                redirectUriBuilder.queryParam("message", new Object[]{configuration.getDefaultConfiguration() != false ? "google_api_oauth_polaczenie_udane_i_zastosowane" : "google_api_oauth_polaczenie_udane_ale_niezastosowane"});
            }
            catch (Exception e) {
                log.error("B\u0142\u0105d po\u0142\u0105czenia z Google Api dla konfiguracji o id: " + googleApiAuthId, (Throwable)e);
                redirectUriBuilder.queryParam("error", new Object[]{"polaczenie_nieudane"});
                redirectUriBuilder.queryParam("errorMsg", new Object[]{e.getMessage() != null ? e.getMessage() : e});
            }
        } else {
            log.error("Brak konfiguracji Google Api o id: " + googleApiAuthId);
            redirectUriBuilder.queryParam("error", new Object[]{"polaczenie_nieudane"});
        }
        return new RedirectView(redirectUriBuilder.toUriString());
    }

    @ConstructorProperties(value={"googleDriveApiClient", "googleDriveInternalService", "systemPropertiesHelper", "googleApiAuthenticationService"})
    @Autowired
    public OAuth2GoogleApiController(GoogleDriveApiClient googleDriveApiClient, GoogleDriveInternalService googleDriveInternalService, SystemPropertiesHelper systemPropertiesHelper, GoogleApiAuthenticationService googleApiAuthenticationService) {
        this.googleDriveApiClient = googleDriveApiClient;
        this.googleDriveInternalService = googleDriveInternalService;
        this.systemPropertiesHelper = systemPropertiesHelper;
        this.googleApiAuthenticationService = googleApiAuthenticationService;
    }
}

