/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.action.ProcesActivityAction;
import com.plusmpm.struts.action.ShowArchiveViewsAction;
import com.plusmpm.struts.form.StrutsUploadForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.exception.FileSizeLimitExceededException;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.CoreServiceFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.exception.ServiceException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class UploadFileAction
extends DispatchAction {
    public static Logger log = Logger.getLogger(UploadFileAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String values;
        String description;
        String docClassId;
        String processKey;
        String activityId;
        Boolean success;
        StringBuffer ufMessage;
        boolean archiveRelease;
        String redirect;
        HttpSession session;
        block20: {
            session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("disconnect");
            }
            String sUserName = (String)session.getAttribute("username");
            redirect = request.getParameter("redirect");
            log.info((Object)"******************************UploadFileAction********************");
            archiveRelease = false;
            ufMessage = new StringBuffer();
            success = false;
            activityId = "";
            processKey = "";
            docClassId = "";
            description = "";
            values = "";
            try {
                String rightType;
                StrutsUploadForm uploadForm = (StrutsUploadForm)form;
                String sValues = uploadForm.getValues();
                if (sValues != null) {
                    sValues = Tools.decodeUTF8String((String)sValues);
                }
                log.info((Object)("uploadForm = " + String.valueOf(uploadForm)));
                activityId = uploadForm.getActivityId();
                processKey = uploadForm.getProcessKey();
                description = uploadForm.getDescription();
                values = uploadForm.getValues();
                if (StringUtils.isEmpty((CharSequence)activityId)) {
                    activityId = null;
                }
                log.info((Object)("uploadForm = " + String.valueOf(uploadForm)));
                log.info((Object)("activityId: " + activityId + " processKey:" + processKey));
                if (StringUtils.isEmpty((CharSequence)processKey)) {
                    archiveRelease = true;
                    rightType = "archive";
                } else {
                    archiveRelease = false;
                    rightType = "process";
                }
                log.info((Object)("bArchiveRelease:" + archiveRelease));
                docClassId = uploadForm.getDocclassId();
                DocumentClass documentClass = (DocumentClass)ServiceFactory.getDocumentClassService().get((Serializable)new Long(docClassId));
                try {
                    if (!this.authorizeUploadDocument(sUserName, new Long(docClassId), rightType)) {
                        throw new IllegalAccessException("User [" + sUserName + "] has not right to upload document from" + rightType + ".");
                    }
                    if (this.isTokenValid(request, true)) {
                        AddDocumentResultMeta addedDocumentResult;
                        this.resetToken(request);
                        String message = uploadForm.validateForm();
                        if (!message.equals("")) {
                            ufMessage.append(message);
                            if (StringUtils.isEmpty((CharSequence)redirect)) {
                                return UploadFileAction.redirect(archiveRelease, mapping, form, request, response, processKey, activityId, docClassId, description, values, success, ufMessage);
                            }
                            session.setAttribute("message", (Object)ufMessage.toString());
                            session.setAttribute("success", (Object)success);
                            response.sendRedirect(redirect);
                            return null;
                        }
                        FileService fileService = (FileService)SpringContext.getBean(FileService.class);
                        Map documentFormIdxs = this.readIndexes(sValues);
                        documentFormIdxs = fileService.convertIndexTypes(documentFormIdxs, new Long(docClassId).longValue());
                        boolean saveAsNewVersionIfPossible = uploadForm.getAsNewVersion() != null && uploadForm.getAsNewVersion().equals("on");
                        boolean attachToClosedActivities = uploadForm.getToClosedActivities() != null && uploadForm.getToClosedActivities().equals("true");
                        String fileName = uploadForm.getTheFile().getFileName();
                        DocumentService documentService = ServiceFactory.getDocumentService();
                        DocumentDefinition fileDefinition = new DocumentDefinition();
                        fileDefinition.setDocumentClassId(new Long(docClassId));
                        fileDefinition.setFileName(fileName);
                        fileDefinition.setDescription(uploadForm.getDescription());
                        fileDefinition.setUserName(sUserName);
                        fileDefinition.setInputStream(uploadForm.getTheFile().getInputStream());
                        fileDefinition.setIndexes(documentFormIdxs);
                        fileDefinition.setSaveAsNewVersion(saveAsNewVersionIfPossible);
                        fileDefinition.setAttachToClosedActivities(attachToClosedActivities);
                        DocumentClassActionService documentActionService = CoreServiceFactory.getDocumentClassActionService();
                        if (archiveRelease) {
                            addedDocumentResult = documentService.addDocumentWithMetaResult(fileDefinition);
                            WfDocument document = addedDocumentResult.getDocument();
                            try {
                                documentActionService.executeArchiveActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE, addedDocumentResult.getSavedAsNewVersion());
                            }
                            catch (ServiceException e) {
                                ServiceFactory.getDocumentService().deleteDocument(document);
                                throw e;
                            }
                        }
                        fileDefinition.setProcessId(processKey);
                        fileDefinition.setActivityId(activityId);
                        addedDocumentResult = documentService.addDocumentWithMetaResult(fileDefinition);
                        WfDocument document = addedDocumentResult.getDocument();
                        try {
                            documentActionService.executeProcessActions(document, DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, processKey, activityId, addedDocumentResult.getSavedAsNewVersion());
                        }
                        catch (ServiceException e) {
                            ServiceFactory.getDocumentService().deleteDocument(document);
                            throw e;
                        }
                        log.info((Object)"Trying commit transaction");
                        log.info((Object)"Commit transaction OK");
                        String sDocClassName = documentClass.getName();
                        success = true;
                        ufMessage.append(MessageHelper.getMessage((String)"Plik") + ": " + fileName + " " + MessageHelper.getMessage((String)"pomyslnie_dodany_do_klasy_dokumentow") + " " + sDocClassName);
                        break block20;
                    }
                    log.info((Object)"Blad : Token niepoprawny - prawdopodobnie resubmit formy (refresh )");
                    success = false;
                }
                catch (ServiceException e) {
                    success = false;
                    if (e.getCause() instanceof FileSizeLimitExceededException) {
                        ufMessage.append(MessageHelper.getMessage((String)"Przekroczono_maksymalny_rozmiar_pliku", (Object[])new Object[]{documentClass.getMaxFileSize() / 1024L}));
                        break block20;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                ufMessage.append(MessageHelper.getMessage((String)"Blad_przesylania_dokumentu") + ".");
                success = false;
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)redirect)) {
            session.setAttribute("message", (Object)ufMessage.toString());
            session.setAttribute("success", (Object)success);
            response.sendRedirect(redirect);
            return null;
        }
        return UploadFileAction.redirect(archiveRelease, mapping, form, request, response, processKey, activityId, docClassId, description, values, success, ufMessage);
    }

    private Map<Long, Object> readIndexes(String sValues) {
        HashMap<Long, Object> map = new HashMap<Long, Object>();
        try {
            if (StringUtils.isNotBlank((CharSequence)sValues)) {
                String[] sSets = null;
                sSets = sValues.split(URLEncoder.encode("&", "UTF-8"));
                for (int i = 0; i < sSets.length; ++i) {
                    String[] sSet = sSets[i].split(URLEncoder.encode("=", "UTF-8"));
                    if (sSet.length <= 1) continue;
                    map.put(new Long(sSet[0]), sSet[1]);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authorizeUploadDocument(String userId, Long documentClassId, String type) {
        Connection connection = null;
        try {
            connection = DBUtils.connectToDB();
            String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).release().custom((Object)type).build();
            int right = Authorization.checkRight((Connection)connection, (String)rightLevel, (String)userId, (boolean)false, (boolean)false);
            if (right == 0 || right == 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeConnection((Connection)connection);
        }
        return false;
    }

    private static ActionForward redirect(boolean bArchiveRelease, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String processKey, String activityId, String docClassId, String description, String values, boolean success, StringBuffer ufMessage) {
        if (bArchiveRelease) {
            ShowArchiveViewsAction showArchiveViewsAction = new ShowArchiveViewsAction();
            showArchiveViewsAction.m_bDefaultTab = true;
            showArchiveViewsAction.m_sDefaultTab = "release";
            showArchiveViewsAction.m_sMessage = ufMessage.toString();
            showArchiveViewsAction.m_sMessageType = success ? "success" : "error";
            request.getSession().setAttribute("message", (Object)true);
            log.info((Object)("message: " + ufMessage.toString()));
            request.setAttribute("audit", (Object)UploadFileAction.buildAudit(success, processKey, activityId, description, docClassId, values));
            return showArchiveViewsAction.execute(mapping, form, request, response);
        }
        try {
            request.setAttribute("activityId", (Object)activityId);
            request.setAttribute("processId", (Object)processKey);
            ProcesActivityAction procesActivityAction = new ProcesActivityAction();
            request.setAttribute("audit", (Object)UploadFileAction.buildAudit(success, processKey, activityId, description, docClassId, values));
            return procesActivityAction.execute(mapping, form, request, response);
        }
        catch (Exception e) {
            log.info((Object)("Exception:" + e.getMessage()));
            return mapping.findForward("welcome");
        }
    }

    private static AuditWrapper buildAudit(boolean success, String processKey, String activityId, String description, String docClassId, String values) {
        AuditTypes auditType = AuditTypes.AUDIT_UPLOAD_FILE_FROM_ARCHIVE;
        if (StringUtils.isNotBlank((CharSequence)processKey)) {
            auditType = AuditTypes.AUDIT_UPLOAD_FILE_FROM_PROCESS;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processKey", processKey);
        params.put("activityId", activityId);
        params.put("description", description);
        params.put("docclassId", docClassId);
        params.put("values", values);
        return AuditBuilder.getInstance().params(params).type(auditType).success(success).build();
    }
}

