/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.workflow.process.map;

import com.suncode.pwfl.web.dto.workflow.process.map.AcceptButtonDto;
import com.suncode.pwfl.web.dto.workflow.process.map.ActivityDto;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import com.suncode.pwfl.web.dto.workflow.process.map.TransitionDto;
import com.suncode.pwfl.web.dto.workflow.process.map.VariableDto;
import com.suncode.pwfl.web.dto.workflow.process.map.VariableRefDto;
import com.suncode.pwfl.web.dto.workflow.process.map.element.ActivityElementDto;
import com.suncode.pwfl.web.dto.workflow.process.map.element.ProcessElementDto;
import com.suncode.pwfl.workflow.process.map.AcceptButton;
import com.suncode.pwfl.workflow.process.map.Activity;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.process.map.Variable;
import com.suncode.pwfl.workflow.process.map.VariableRef;
import com.suncode.pwfl.workflow.process.map.element.ActivityElement;
import com.suncode.pwfl.workflow.process.map.element.ProcessElement;
import com.suncode.pwfl.workflow.process.map.transition.Transition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ProcessMapper {
    public ProcessDto toDto(Process process) {
        List<ActivityDto> activities = Optional.ofNullable(process.getActivities()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        List<TransitionDto> transitions = Optional.ofNullable(process.getTransitions()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        List<VariableDto> variables = Optional.ofNullable(process.getVariables()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        return ProcessDto.builder().id(process.getId()).name(process.getName()).activities(activities).transitions(transitions).variables(variables).build();
    }

    private ActivityDto toDto(Activity activity) {
        List<VariableRefDto> variableRefs = Optional.ofNullable(activity.getVariableRefs()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        List<AcceptButtonDto> buttons = Optional.ofNullable(activity.getAcceptButtons()).orElseGet(ArrayList::new).stream().map(this::toDto).toList();
        return ActivityDto.builder().id(activity.getId()).name(activity.getName()).joinType(activity.getJoinType()).variableRefs(variableRefs).acceptButtons(buttons).build();
    }

    private TransitionDto toDto(Transition transition) {
        return TransitionDto.builder().id(transition.getId()).sourceId(transition.getSourceId()).targetId(transition.getTargetId()).build();
    }

    private VariableDto toDto(Variable variable) {
        return VariableDto.builder().id(variable.getId()).name(variable.getName()).type(variable.getType()).build();
    }

    private VariableRefDto toDto(VariableRef variableRef) {
        return VariableRefDto.builder().id(variableRef.getId()).type(variableRef.getType()).position(variableRef.getPosition()).build();
    }

    private AcceptButtonDto toDto(AcceptButton acceptButton) {
        return AcceptButtonDto.builder().id(acceptButton.getId()).name(acceptButton.getName()).targetActivityId(acceptButton.getTargetActivityId()).build();
    }

    public Process toProcess(ProcessDto processDto) {
        Process process = new Process(processDto.getId(), processDto.getName());
        List<Variable> variables = processDto.getVariables().stream().map(this::toVariable).toList();
        process.getVariables().addAll(variables);
        List<Activity> activities = processDto.getActivities().stream().map(this::toActivity).toList();
        process.getActivities().addAll(activities);
        List<Transition> transitions = processDto.getTransitions().stream().map(this::toTransition).toList();
        process.getTransitions().addAll(transitions);
        return process;
    }

    private Variable toVariable(VariableDto variableDto) {
        return new Variable(variableDto.getType(), variableDto.getId(), variableDto.getName());
    }

    private Activity toActivity(ActivityDto activityDto) {
        Activity activity = new Activity(activityDto.getId(), activityDto.getName(), activityDto.getJoinType());
        List<VariableRef> variableRefs = activityDto.getVariableRefs().stream().map(this::toVariableRef).toList();
        activity.getVariableRefs().addAll(variableRefs);
        List<AcceptButton> buttons = activityDto.getAcceptButtons().stream().map(this::toAcceptButton).toList();
        activity.getAcceptButtons().addAll(buttons);
        return activity;
    }

    private VariableRef toVariableRef(VariableRefDto variableRefDto) {
        return new VariableRef(variableRefDto.getId(), variableRefDto.getType(), variableRefDto.getPosition().intValue());
    }

    private AcceptButton toAcceptButton(AcceptButtonDto acceptButtonDto) {
        return new AcceptButton(acceptButtonDto.getId(), acceptButtonDto.getName(), acceptButtonDto.getTargetActivityId());
    }

    private Transition toTransition(TransitionDto transitionDto) {
        return new Transition(transitionDto.getId(), transitionDto.getSourceId(), transitionDto.getTargetId());
    }

    public ProcessElement toElement(ProcessElementDto processElementDto) {
        List<ActivityElement> activityElements = processElementDto.getActivities().stream().map(this::toElement).toList();
        ProcessElement processElement = new ProcessElement();
        processElement.getActivities().addAll(activityElements);
        return processElement;
    }

    private ActivityElement toElement(ActivityElementDto activityElementDto) {
        return new ActivityElement(activityElementDto.getX(), activityElementDto.getY());
    }
}

