/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.plugin;

import com.suncode.org.apache.struts.tiles.ComponentContext;
import com.suncode.org.apache.struts.tiles.ComponentDefinition;
import com.suncode.org.apache.struts.tiles.Controller;
import com.suncode.plugin.framework.web.support.decorator.ViewDecorator;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.util.Assert;

public class TilesDecorator
implements ViewDecorator {
    private ComponentDefinition componentDefinition;

    public TilesDecorator(ComponentDefinition componentDefinition) {
        Assert.notNull((Object)componentDefinition, (String)"Component definition must not be null");
        this.componentDefinition = componentDefinition;
    }

    public void decorate(String content, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean include = false;
        this.componentDefinition.put("body", (Object)content, true);
        ComponentContext componentContext = ComponentContext.getContext((ServletRequest)request);
        if (componentContext == null) {
            componentContext = new ComponentContext(this.componentDefinition.getAttributes());
            ComponentContext.setContext((ComponentContext)componentContext, (ServletRequest)request);
        } else {
            include = true;
            componentContext.addMissing(this.componentDefinition.getAttributes());
        }
        try {
            Controller controller = this.componentDefinition.getOrCreateController();
            if (controller != null) {
                controller.perform(componentContext, request, response, request.getServletContext());
            }
        }
        catch (InstantiationException e) {
            throw new ServletException("Nie uda\u0142o si\u0119 stworzy\u0107 kontrollera dla definicji [" + this.componentDefinition.getName() + "]", (Throwable)e);
        }
        String url = this.componentDefinition.getPath();
        if (include) {
            this.doInclude(url, request, response);
        } else {
            this.doForward(url, request, response);
        }
    }

    private void doInclude(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.getRequestDispatcher(path, request).include((ServletRequest)request, (ServletResponse)response);
    }

    private void doForward(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            this.getRequestDispatcher(path, request).include((ServletRequest)request, (ServletResponse)response);
        } else {
            this.getRequestDispatcher(path, request).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private RequestDispatcher getRequestDispatcher(String path, HttpServletRequest request) throws ServletException {
        RequestDispatcher rd = request.getRequestDispatcher(path);
        if (rd == null) {
            throw new ServletException("Nie znaleziono RequestDispatchera  dla adresu [" + path + "]");
        }
        return rd;
    }
}

