/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.administration.archive.AssociatedIndexes;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.beans.ConstructorProperties;

public class AssociatedIndexesDto {
    private Long id;
    private Long parentIndexId;
    private Long childIndexId;
    private Long parentIndexOrder;
    private String parentIndexName;
    private String childIndexName;
    private String type;

    public static AssociatedIndexesDto fromEntity(AssociatedIndexes associatedIndexes) {
        return AssociatedIndexesDto.builder().id(associatedIndexes.getId()).childIndexId(associatedIndexes.getChildIndex().getId()).parentIndexId(associatedIndexes.getParentIndex().getId()).parentIndexName(associatedIndexes.getParentIndex().getName()).childIndexName(associatedIndexes.getChildIndex().getName()).build();
    }

    public static AssociatedIndexesDto fromLinkConnection(LinkConnection linkConnection) {
        LinkService linkService = ServiceFactory.getLinkService();
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        return AssociatedIndexesDto.builder().id(linkConnection.getId()).childIndexId(linkConnection.getDocumentClassIndex().getId()).parentIndexId(linkConnection.getLinkIndex().getId()).parentIndexName(linkService.getLinkIndexTranslation(linkConnection.getLinkIndex().getId(), TranslatedFieldType.NAME)).parentIndexOrder(linkConnection.getLinkIndex().getOrder()).childIndexName(documentClassService.getDocumentClassIndexTranslation(linkConnection.getDocumentClassIndex().getId(), TranslatedFieldType.NAME)).type(linkConnection.getLinkIndex().getType()).build();
    }

    public static AssociatedIndexesDtoBuilder builder() {
        return new AssociatedIndexesDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getParentIndexId() {
        return this.parentIndexId;
    }

    public Long getChildIndexId() {
        return this.childIndexId;
    }

    public Long getParentIndexOrder() {
        return this.parentIndexOrder;
    }

    public String getParentIndexName() {
        return this.parentIndexName;
    }

    public String getChildIndexName() {
        return this.childIndexName;
    }

    public String getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setParentIndexId(Long parentIndexId) {
        this.parentIndexId = parentIndexId;
    }

    public void setChildIndexId(Long childIndexId) {
        this.childIndexId = childIndexId;
    }

    public void setParentIndexOrder(Long parentIndexOrder) {
        this.parentIndexOrder = parentIndexOrder;
    }

    public void setParentIndexName(String parentIndexName) {
        this.parentIndexName = parentIndexName;
    }

    public void setChildIndexName(String childIndexName) {
        this.childIndexName = childIndexName;
    }

    public void setType(String type) {
        this.type = type;
    }

    @ConstructorProperties(value={"id", "parentIndexId", "childIndexId", "parentIndexOrder", "parentIndexName", "childIndexName", "type"})
    public AssociatedIndexesDto(Long id, Long parentIndexId, Long childIndexId, Long parentIndexOrder, String parentIndexName, String childIndexName, String type) {
        this.id = id;
        this.parentIndexId = parentIndexId;
        this.childIndexId = childIndexId;
        this.parentIndexOrder = parentIndexOrder;
        this.parentIndexName = parentIndexName;
        this.childIndexName = childIndexName;
        this.type = type;
    }

    public AssociatedIndexesDto() {
    }

    public static class AssociatedIndexesDtoBuilder {
        private Long id;
        private Long parentIndexId;
        private Long childIndexId;
        private Long parentIndexOrder;
        private String parentIndexName;
        private String childIndexName;
        private String type;

        AssociatedIndexesDtoBuilder() {
        }

        public AssociatedIndexesDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AssociatedIndexesDtoBuilder parentIndexId(Long parentIndexId) {
            this.parentIndexId = parentIndexId;
            return this;
        }

        public AssociatedIndexesDtoBuilder childIndexId(Long childIndexId) {
            this.childIndexId = childIndexId;
            return this;
        }

        public AssociatedIndexesDtoBuilder parentIndexOrder(Long parentIndexOrder) {
            this.parentIndexOrder = parentIndexOrder;
            return this;
        }

        public AssociatedIndexesDtoBuilder parentIndexName(String parentIndexName) {
            this.parentIndexName = parentIndexName;
            return this;
        }

        public AssociatedIndexesDtoBuilder childIndexName(String childIndexName) {
            this.childIndexName = childIndexName;
            return this;
        }

        public AssociatedIndexesDtoBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AssociatedIndexesDto build() {
            return new AssociatedIndexesDto(this.id, this.parentIndexId, this.childIndexId, this.parentIndexOrder, this.parentIndexName, this.childIndexName, this.type);
        }

        public String toString() {
            return "AssociatedIndexesDto.AssociatedIndexesDtoBuilder(id=" + this.id + ", parentIndexId=" + this.parentIndexId + ", childIndexId=" + this.childIndexId + ", parentIndexOrder=" + this.parentIndexOrder + ", parentIndexName=" + this.parentIndexName + ", childIndexName=" + this.childIndexName + ", type=" + this.type + ")";
        }
    }
}

