/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks.dto;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskDtoHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskPeriod;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskInvalidHoursRangeException;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.Assert;

public record AddScheduledTaskDto(String name, String description, String method, String className, List<ParameterInfo> params, String categoryName, Long categoryId, String firstRun, Integer startingHour, Integer endingHour, Long maxWorkingMinutes, Boolean executeOnce, ScheduledTaskPeriod period, Boolean active, Boolean saveHistory, List<Long> userIdNotifications, List<String> emailNotifications) {
    public AddScheduledTaskDto {
        Assert.hasText((String)name, (String)MessageHelper.getMessage((String)"Nie_zdefiniowano_wymaganego_pola", (Object[])new Object[]{"name"}));
        Assert.hasText((String)description, (String)MessageHelper.getMessage((String)"Nie_zdefiniowano_wymaganego_pola", (Object[])new Object[]{"description"}));
        Assert.hasText((String)className, (String)MessageHelper.getMessage((String)"Nie_zdefiniowano_wymaganego_pola", (Object[])new Object[]{"className"}));
        Assert.hasText((String)firstRun, (String)MessageHelper.getMessage((String)"Nie_zdefiniowano_wymaganego_pola", (Object[])new Object[]{"firstRun"}));
        params = ListUtils.emptyIfNull(params);
        executeOnce = BooleanUtils.toBooleanDefaultIfNull((Boolean)executeOnce, (boolean)false);
        active = BooleanUtils.toBooleanDefaultIfNull((Boolean)active, (boolean)false);
        saveHistory = BooleanUtils.toBooleanDefaultIfNull((Boolean)saveHistory, (boolean)false);
        userIdNotifications = ListUtils.emptyIfNull(userIdNotifications);
        emailNotifications = ListUtils.emptyIfNull(emailNotifications);
        if (maxWorkingMinutes != null && maxWorkingMinutes < 1L) {
            throw new ScheduledTaskInvalidHoursRangeException("Provided max working time is not a positive number", MessageHelper.getMessage((String)"Provided_max_working_time_is_not_a_positive_number"));
        }
        ScheduledTaskDtoHelper.validateWorkingHours(startingHour, endingHour, period.value(), period.unit());
    }
}

