/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.plusmpm.database.scheduledTasks.ScheduledTaskHistory;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskHistoryDAO;
import com.suncode.pwfl.administration.scheduledtask.file.ScheduledTaskResultFileHelper;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ScheduledTaskHistoryDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scheduledtasks/history"})
@Api(tags={"scheduled tasks"})
public class ScheduledTaskHistoryController {
    private static final Logger log = LoggerFactory.getLogger(ScheduledTaskHistoryController.class);
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private ScheduledTaskResultFileHelper scheduledTaskResultFileHelper;

    @ApiOperation(value="(Admin) Downloading history of scheduled task", notes="Retrieves a history of scheduled task")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping(value={"by/task"})
    @ResponseBody
    public CountedResult<ScheduledTaskHistoryDto> getHistoryByTaskId(@ApiParam(value="Id of the scheduled task", required=true) @RequestParam Long taskId, @ApiParam(value="Result number from which results are to be returned") @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results") @RequestParam(required=false) Integer limit) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return (CountedResult)TransactionWrapper.get().doInHibernateTransaction(session -> {
            List historyEntries = ScheduledTaskHistoryDAO.getByTaskId((Long)taskId, (int)(start == null ? 0 : start), (int)(limit == null ? 0 : limit));
            List historyDtoList = historyEntries.stream().map(historyEntity -> {
                List resultFiles = this.scheduledTaskResultFileHelper.getResultFiles(historyEntity);
                return new ScheduledTaskHistoryDto((ScheduledTaskHistory)historyEntity, resultFiles);
            }).collect(Collectors.toList());
            Long count = ScheduledTaskHistoryDAO.getByTaskIdCount((Long)taskId);
            return new CountedResult(count.longValue(), historyDtoList);
        });
    }
}

