/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.scheduledTasks.PeriodUnit;
import com.plusmpm.database.scheduledTasks.ScheduledTaskCategory;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskCategoryDAO;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.plusmpm.util.scheduledTasks.AbstractPeriodicTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.email.ScheduledTaskEmailNotification;
import com.suncode.pwfl.administration.scheduledtask.email.ScheduledTaskUserNotification;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterFinder;
import com.suncode.pwfl.administration.scheduledtask.service.PeriodicTaskResolver;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodFinder;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodParameter;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.Sneaky;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskAuditParameter;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskDtoHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskParameterBuilder;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.AddScheduledTaskDto;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskInvalidHoursRangeException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskNotAvailableException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.method.ScheduledTaskReceivedParametersValidator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"scheduledtasks"})
@Api(tags={"scheduled tasks"})
public class NewScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(NewScheduledTaskController.class);
    private final ScheduledTaskService scheduledTaskService;
    private final ScheduledTaskHelper scheduledTaskHelper;
    private final ScheduledTaskParameterFinder scheduledTaskParameterFinder;
    private final ScheduledTaskMethodFinder scheduledTaskMethodFinder;
    private final ScheduledTaskParameterBuilder scheduledTaskParameterBuilder;
    private final ScheduledTaskReceivedParametersValidator scheduledTaskReceivedParametersValidator;
    private final AuthorizationHelper authorizationHelper;
    private final TomcatService tomcatService;
    private final UserService userService;
    private final TransactionWrapper transactionWrapper;
    private final PeriodicTaskResolver periodicTaskResolver;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TypeReference<LinkedList<ParameterInfo>> parameterInfoType = new TypeReference<LinkedList<ParameterInfo>>(){};
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="(Admin) Downloading a list of available scheduled tasks", notes="Retrieves a list of available scheduled tasks")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @GetMapping(value={"available"})
    @ResponseBody
    public ResponseEntity<CountedResult<ScheduledTaskMethodDto>> findScheduledTasks(@ApiParam(value="Name of the scheduled task class") @RequestParam(required=false) String className) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            List methodsInfo = StringUtils.isNotBlank((CharSequence)className) ? this.scheduledTaskMethodFinder.findScheduledTaskMethods(className) : this.scheduledTaskMethodFinder.findScheduledTaskMethods();
            CountedResult result = new CountedResult();
            result.setData(methodsInfo);
            result.setTotal((long)methodsInfo.size());
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ClassNotFoundException e) {
            log.info("Nie znaleziono szukanej klasy");
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="(Admin) Saving new scheduled task", notes="The executed query adds new scheduled task. The query is a JSON object with the following fields \n- **name** - name of the new scheduled task\n- **description** - description\n- **method** - method\n- **className** -  class name of the scheduled task\n- **params** - list of parameter objects:\n  - position - position of the parameter (starting from 0)\n  - type - type of the parameter\n  - value - object representing information about parameter value \n    - valueType - single/array\n    - value - value of the parameter(with type single) or list of parameters (with type array) Example:\n  `[{\"position\":0,\"value\":{\"valueType\":\"single\",\"value\":\"test\"},\"type\":\"java.lang.String\"}]`\n- **categoryName** - category name\n- **categoryId** - category id\n- **firstRun** - date of the first run of the scheduled task\n- **executeOnce** - should be executed only once\n- **period** - object containing the period info; \n  - unit - MINUTES/HOURS/DAYS/MONTHS(30 days)\n  - value - number\n- **active** - is task active\n- **saveHistory** - should save history of the task execution")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    @PostMapping
    @ResponseBody
    public RestResult saveScheduledTask(@ApiParam(value="Scheduled task configuration", required=true) @RequestBody AddScheduledTaskDto dto) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            throw new ServiceException(this.messageHelper.getMessage("Nieprawid\u0142owy_tryb_serwera"));
        }
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName());
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("name", (Object)dto.name()).param("description", (Object)dto.description()).param("method", (Object)dto.method()).param("classname", (Object)dto.className()).param("categoryName", (Object)dto.categoryName()).param("firstRun", (Object)dto.firstRun()).param("runOnce", (Object)dto.executeOnce()).param("periodValue", (Object)dto.period().value()).param("periodUnit", dto.period().value() != null ? dto.period().unit().getAuditKey() : null).param("active", (Object)dto.active()).param("savehistory", (Object)dto.saveHistory()).param("startingHour", dto.startingHour() != null ? dto.startingHour() : "").param("endingHour", dto.endingHour() != null ? dto.endingHour() : "").param("maxWorkingMinutes", dto.maxWorkingMinutes() != null ? dto.maxWorkingMinutes() : "").param("userIdNotifications", (Object)dto.userIdNotifications().stream().map(String::valueOf).collect(Collectors.joining(", "))).param("emailNotifications", (Object)String.join((CharSequence)", ", dto.emailNotifications()));
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            String method = dto.method();
            if (this.scheduledTaskHelper.isComponent(dto.className())) {
                method = "execute";
                auditParamsBuilder.param("method", (Object)dto.method());
            }
            auditParamsBuilder.param("parameters", (Object)this.getSerializedAuditParameters(dto.params()));
            ScheduledTaskMethodDto methodDto = (ScheduledTaskMethodDto)this.scheduledTaskMethodFinder.findScheduledTaskMethod(dto.className(), method, this.getScheduledTaskMethodParameters(dto.params())).orElseThrow(() -> new ScheduledTaskNotAvailableException(this.messageHelper.getMessage("Nie_znaleziono_metody_zadania_zaplanowanego")));
            this.scheduledTaskReceivedParametersValidator.validateReceivedParametersAgainstMethod(dto.params(), methodDto, true);
            long id = (Long)this.transactionWrapper.doInHibernateTransaction(session -> (Long)Sneaky.throwing(() -> this.saveScheduledTask(session, dto, methodDto)));
            ScheduledTasksTable task = ScheduledTasksTableDAO.get((Long)id);
            if (task.getIs_active().booleanValue()) {
                AbstractPeriodicTask periodicTask = this.periodicTaskResolver.getInstance(task);
                ScheduledTasksManager.getInstance().getScheduler().schedule(periodicTask);
            }
            auditBuilder.success(true);
            RestResult restResult = new RestResult(true);
            return restResult;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            auditBuilder.params(auditParamsBuilder.build()).build().log();
        }
    }

    private long saveScheduledTask(Session session, AddScheduledTaskDto dto, ScheduledTaskMethodDto methodDto) throws ParseException, IOException {
        Date firstRunDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dto.firstRun());
        Long periodValue = dto.period().value();
        PeriodUnit periodUnit = dto.period().unit();
        ScheduledTaskCategory taskCategory = this.getScheduledTaskCategory(session, dto.categoryId(), dto.categoryName());
        ScheduledTasksTable task = new ScheduledTasksTable(dto.name(), dto.description(), dto.active(), dto.className(), dto.method(), firstRunDate, firstRunDate, null, dto.executeOnce(), periodValue, dto.saveHistory(), taskCategory);
        task.setScheduled_tasks_parameters(this.scheduledTaskParameterBuilder.buildTaskParameters(dto.params(), task));
        this.appendRemainingParameters(task, methodDto);
        task.setPeriodUnit((PeriodUnit)(periodValue != null ? periodUnit : null));
        task.setStartingHour(dto.startingHour());
        task.setEndingHour(dto.endingHour());
        task.setMaxWorkingMinutes(dto.maxWorkingMinutes());
        task.setUserNotifications((List)dto.userIdNotifications().stream().map(x$0 -> this.userService.getUser(x$0, new String[0])).map(user -> ScheduledTaskUserNotification.builder().task(task).user(user).build()).collect(Collectors.toCollection(ArrayList::new)));
        task.setEmailNotifications((List)dto.emailNotifications().stream().map(email -> ScheduledTaskEmailNotification.builder().task(task).email(email).build()).collect(Collectors.toCollection(ArrayList::new)));
        this.scheduledTaskService.addScheduledTask(session, task);
        return task.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"new"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> saveNewScheduledTask(@RequestParam String name, @RequestParam String description, @RequestParam(required=false) String method, @RequestParam String className, @RequestParam String params, @RequestParam(required=false) String categoryName, @RequestParam(required=false) Long categoryId, @RequestParam String firstRun, @RequestParam(required=false) Integer startingHour, @RequestParam(required=false) Integer endingHour, @RequestParam(required=false) Long maxWorkingMinutes, @RequestParam(required=false) String executeOnce, @RequestParam(required=false) Long periodValue, @RequestParam(required=false) PeriodUnit periodUnit, @RequestParam(required=false) String active, @RequestParam(required=false) String saveHistory, @RequestParam(required=false) List<String> userNameNotifications, @RequestParam(required=false) List<String> emailNotifications) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        log.info("Dodawanie nowego zadania zaplanowanego...");
        boolean runOnce = StringUtils.equals((CharSequence)executeOnce, (CharSequence)"on");
        boolean isActive = StringUtils.equals((CharSequence)active, (CharSequence)"on");
        boolean logHistory = StringUtils.equals((CharSequence)saveHistory, (CharSequence)"on");
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName());
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("name", (Object)name).param("description", (Object)description).param("method", (Object)method).param("classname", (Object)className).param("categoryName", (Object)categoryName).param("firstRun", (Object)firstRun).param("runOnce", (Object)runOnce).param("periodValue", (Object)periodValue).param("periodUnit", (Object)(periodValue != null ? periodUnit.getAuditKey() : null)).param("active", (Object)isActive).param("savehistory", (Object)logHistory).param("startingHour", startingHour != null ? startingHour : "").param("endingHour", endingHour != null ? endingHour : "").param("maxWorkingMinutes", maxWorkingMinutes != null ? maxWorkingMinutes : "").param("userNameNotifications", (Object)ListUtils.emptyIfNull(userNameNotifications).stream().map(String::valueOf).collect(Collectors.joining(", "))).param("emailNotifications", (Object)String.join((CharSequence)", ", ListUtils.emptyIfNull(emailNotifications)));
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            if (this.scheduledTaskHelper.isComponent(className)) {
                method = "execute";
                auditParamsBuilder.param("method", (Object)method);
            }
            List dtoParamList = (List)this.objectMapper.readValue(params, this.parameterInfoType);
            String serializedAuditParameters = this.getSerializedAuditParameters(dtoParamList);
            auditParamsBuilder.param("parameters", (Object)serializedAuditParameters);
            List<ScheduledTaskMethodParameter> queryMethodParameters = this.getScheduledTaskMethodParameters(dtoParamList);
            ScheduledTaskMethodDto methodDto = (ScheduledTaskMethodDto)this.scheduledTaskMethodFinder.findScheduledTaskMethod(className, method, queryMethodParameters).orElseThrow(() -> new ScheduledTaskNotAvailableException(this.messageHelper.getMessage("Nie_znaleziono_metody_zadania_zaplanowanego")));
            this.scheduledTaskReceivedParametersValidator.validateReceivedParametersAgainstMethod(dtoParamList, methodDto, true);
            String actualMethod = method;
            long id = (Long)this.transactionWrapper.doInHibernateTransaction(session -> (Long)Sneaky.throwing(() -> {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date firstRunDate = dateFormatter.parse(firstRun);
                ScheduledTaskCategory taskCategory = this.getScheduledTaskCategory(session, categoryId, categoryName);
                if (maxWorkingMinutes != null && maxWorkingMinutes < 1L) {
                    throw new ScheduledTaskInvalidHoursRangeException("Provided max working time is not a positive number", this.messageHelper.getMessage("Provided_max_working_time_is_not_a_positive_number"));
                }
                ScheduledTaskDtoHelper.validateWorkingHours(startingHour, endingHour, periodValue, periodUnit);
                ScheduledTasksTable task = new ScheduledTasksTable(name, description, Boolean.valueOf(isActive), className, actualMethod, firstRunDate, firstRunDate, null, Boolean.valueOf(runOnce), periodValue, Boolean.valueOf(logHistory), taskCategory);
                task.setPeriodUnit((PeriodUnit)(periodValue != null ? periodUnit : null));
                task.setStartingHour(startingHour);
                task.setEndingHour(endingHour);
                task.setMaxWorkingMinutes(maxWorkingMinutes);
                task.setScheduled_tasks_parameters(this.scheduledTaskParameterBuilder.buildTaskParameters(dtoParamList, task));
                this.appendRemainingParameters(task, methodDto);
                task.setUserNotifications((List)ListUtils.emptyIfNull((List)userNameNotifications).stream().map(x$0 -> this.userService.getUser(x$0, new String[0])).map(user -> ScheduledTaskUserNotification.builder().task(task).user(user).build()).collect(Collectors.toCollection(ArrayList::new)));
                task.setEmailNotifications((List)ListUtils.emptyIfNull((List)emailNotifications).stream().map(email -> ScheduledTaskEmailNotification.builder().task(task).email(email).build()).collect(Collectors.toCollection(ArrayList::new)));
                this.scheduledTaskService.addScheduledTask(session, task);
                return task.getId();
            }));
            ScheduledTasksTable task = ScheduledTasksTableDAO.get((Long)id);
            if (task.getIs_active().booleanValue()) {
                AbstractPeriodicTask periodicTask = this.periodicTaskResolver.getInstance(task);
                ScheduledTasksManager.getInstance().getScheduler().schedule(periodicTask);
            }
            log.info("Zadanie zaplanowane zosta\u0142o dodane.");
            result.put("success", true);
            auditBuilder.success(true);
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (ScheduledTaskInvalidHoursRangeException e) {
            log.error(e.getMessage(), (Throwable)e);
            result.put("success", false);
            result.put("error", e.getLocalizedMessage());
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            result.put("success", false);
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        finally {
            auditBuilder.params(auditParamsBuilder.build()).build().log();
        }
    }

    private void appendRemainingParameters(ScheduledTasksTable newEntity, ScheduledTaskMethodDto methodDto) {
        List newParameterEntities = newEntity.getScheduled_tasks_parameters();
        for (ScheduledTaskMethodDto.Parameter parameterDto : methodDto.getParameters()) {
            Optional newParameterEntityOpt = this.scheduledTaskParameterFinder.findInEntity(newParameterEntities).by(parameterDto);
            if (!newParameterEntityOpt.isEmpty()) continue;
            ScheduledTasksParametersTable newParameterEntity = new ScheduledTasksParametersTable(newEntity, parameterDto.getType(), null, parameterDto.getPosition());
            newParameterEntities.add(newParameterEntity);
        }
    }

    private ScheduledTaskCategory getScheduledTaskCategory(Session session, Long categoryId, String categoryName) {
        ScheduledTaskCategory taskCategory = null;
        if (categoryId != null) {
            taskCategory = ScheduledTaskCategoryDAO.get((Session)session, (Long)categoryId);
        } else if (StringUtils.isNotBlank((CharSequence)categoryName) && (taskCategory = ScheduledTaskCategoryDAO.getByName((Session)session, (String)categoryName)) == null) {
            taskCategory = new ScheduledTaskCategory(categoryName);
            ScheduledTaskCategoryDAO.save((Session)session, (ScheduledTaskCategory)taskCategory);
        }
        return taskCategory;
    }

    private List<ScheduledTaskMethodParameter> getScheduledTaskMethodParameters(List<ParameterInfo> infoList) {
        return infoList.stream().sorted(Comparator.comparing(ParameterInfo::getPosition)).map(parameterInfo -> new ScheduledTaskMethodParameter(parameterInfo.getPosition(), parameterInfo.getType())).collect(Collectors.toList());
    }

    private String getSerializedAuditParameters(List<ParameterInfo> infoList) {
        return infoList.stream().map(ScheduledTaskAuditParameter::from).map(ScheduledTaskAuditParameter::toString).collect(Collectors.joining("\n"));
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ExceptionHandler(value={ServiceException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"scheduledTaskService", "scheduledTaskHelper", "scheduledTaskParameterFinder", "scheduledTaskMethodFinder", "scheduledTaskParameterBuilder", "scheduledTaskReceivedParametersValidator", "authorizationHelper", "tomcatService", "userService", "transactionWrapper", "periodicTaskResolver", "messageHelper"})
    @Autowired
    public NewScheduledTaskController(ScheduledTaskService scheduledTaskService, ScheduledTaskHelper scheduledTaskHelper, ScheduledTaskParameterFinder scheduledTaskParameterFinder, ScheduledTaskMethodFinder scheduledTaskMethodFinder, ScheduledTaskParameterBuilder scheduledTaskParameterBuilder, ScheduledTaskReceivedParametersValidator scheduledTaskReceivedParametersValidator, AuthorizationHelper authorizationHelper, TomcatService tomcatService, UserService userService, TransactionWrapper transactionWrapper, PeriodicTaskResolver periodicTaskResolver, MessageHelperBean messageHelper) {
        this.scheduledTaskService = scheduledTaskService;
        this.scheduledTaskHelper = scheduledTaskHelper;
        this.scheduledTaskParameterFinder = scheduledTaskParameterFinder;
        this.scheduledTaskMethodFinder = scheduledTaskMethodFinder;
        this.scheduledTaskParameterBuilder = scheduledTaskParameterBuilder;
        this.scheduledTaskReceivedParametersValidator = scheduledTaskReceivedParametersValidator;
        this.authorizationHelper = authorizationHelper;
        this.tomcatService = tomcatService;
        this.userService = userService;
        this.transactionWrapper = transactionWrapper;
        this.periodicTaskResolver = periodicTaskResolver;
        this.messageHelper = messageHelper;
    }
}

