/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.scheduledTasks.PeriodUnit;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.plusmpm.util.scheduledTasks.AbstractPeriodicTask;
import com.plusmpm.util.scheduledTasks.ScheduledTasksManager;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.email.ScheduledTaskEmailNotification;
import com.suncode.pwfl.administration.scheduledtask.email.ScheduledTaskUserNotification;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterFinder;
import com.suncode.pwfl.administration.scheduledtask.service.PeriodicTaskResolver;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskEntityMethodValidator;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodFinder;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.Sneaky;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskAuditParameter;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskDtoHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskParameterBuilder;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskConcurrentModificationException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskInvalidHoursRangeException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskNotAvailableException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.method.ScheduledTaskReceivedParametersValidator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduledtasks"})
public class EditScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(EditScheduledTaskController.class);
    @Autowired
    private ScheduledTaskParameterFinder scheduledTaskParameterFinder;
    @Autowired
    private ScheduledTaskMethodFinder scheduledTaskMethodFinder;
    @Autowired
    private ScheduledTaskParameterBuilder scheduledTaskParameterBuilder;
    @Autowired
    private ScheduledTaskEntityMethodValidator scheduledTaskEntityMethodValidator;
    @Autowired
    private ScheduledTaskReceivedParametersValidator scheduledTaskReceivedParametersValidator;
    @Autowired
    private PeriodicTaskResolver periodicTaskResolver;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private TomcatService tomcatService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionWrapper transactionWrapper;
    private MessageHelperBean messageHelperBean;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TypeReference<LinkedList<ParameterInfo>> parameterInfoType = new TypeReference<LinkedList<ParameterInfo>>(){};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> editScheduledTask(@RequestParam Long id, @RequestParam String name, @RequestParam String description, @RequestParam String params, @RequestParam String nextRun, @RequestParam(required=false) Integer startingHour, @RequestParam(required=false) Integer endingHour, @RequestParam(required=false) Long maxWorkingMinutes, @RequestParam(required=false) String executeOnce, @RequestParam(required=false) Long periodValue, @RequestParam(required=false) PeriodUnit periodUnit, @RequestParam(required=false) String active, @RequestParam(required=false) String saveHistory, @RequestParam(required=false) List<String> userNameNotifications, @RequestParam(required=false) List<String> emailNotifications) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        log.info("Edytowanie zadania zaplanowanego...");
        boolean runOnce = StringUtils.equals((CharSequence)executeOnce, (CharSequence)"on");
        boolean isActive = StringUtils.equals((CharSequence)active, (CharSequence)"on");
        boolean logHistory = StringUtils.equals((CharSequence)saveHistory, (CharSequence)"on");
        ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_SCHEDULED_TASK).username(UserContext.current().getUser().getUserName());
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id).param("name", (Object)name).param("description", (Object)description).param("nextRun", (Object)nextRun).param("runOnce", (Object)runOnce).param("periodValue", (Object)periodValue).param("periodUnit", (Object)(periodUnit != null ? periodUnit.getAuditKey() : null)).param("active", (Object)isActive).param("savehistory", (Object)logHistory).param("startingHour", startingHour != null ? startingHour : "").param("endingHour", endingHour != null ? endingHour : "").param("maxWorkingMinutes", maxWorkingMinutes != null ? maxWorkingMinutes : "").param("userNameNotifications", (Object)ListUtils.emptyIfNull(userNameNotifications).stream().map(String::valueOf).collect(Collectors.joining(", "))).param("emailNotifications", (Object)String.join((CharSequence)", ", ListUtils.emptyIfNull(emailNotifications)));
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            this.transactionWrapper.doInHibernateTransaction(session -> Sneaky.throwing(() -> {
                ScheduledTasksTable task = ScheduledTasksTableDAO.getWithParameters((Session)session, (Long)id);
                auditParamsBuilder.param("staticId", (Object)task.getStaticId());
                if (BooleanUtils.isTrue((Boolean)task.getIs_processing())) {
                    throw new ScheduledTaskConcurrentModificationException(String.format("Scheduled task with id %s is during execution - concurrent modification is not allowed.", id));
                }
                List dtoParamList = (List)this.objectMapper.readValue(params, this.parameterInfoType);
                String serializedAuditParameters = dtoParamList.stream().map(ScheduledTaskAuditParameter::from).map(ScheduledTaskAuditParameter::toString).collect(Collectors.joining("\n"));
                auditParamsBuilder.param("parameters", (Object)serializedAuditParameters);
                ScheduledTaskMethodDto methodDto = (ScheduledTaskMethodDto)this.scheduledTaskMethodFinder.findScheduledTaskMethod(task).orElseThrow(() -> new ScheduledTaskNotAvailableException(String.format("Could not find method matching entity with id %d", id)));
                this.scheduledTaskReceivedParametersValidator.validateReceivedParametersAgainstMethod(dtoParamList, methodDto, false);
                this.scheduledTaskEntityMethodValidator.validateEntityParametersAgainstMethod(task, methodDto, false);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date nextRunDate = dateFormatter.parse(nextRun);
                if (maxWorkingMinutes != null && maxWorkingMinutes < 1L) {
                    throw new ScheduledTaskInvalidHoursRangeException("Provided max working time is not a positive number", this.messageHelperBean.getMessage("Provided_max_working_time_is_not_a_positive_number"));
                }
                ScheduledTaskDtoHelper.validateWorkingHours(startingHour, endingHour, periodValue, periodUnit);
                task.setName(name);
                task.setDescription(description);
                task.setRun_once(Boolean.valueOf(runOnce));
                task.setIs_active(Boolean.valueOf(isActive));
                task.setPeriodValue(periodValue);
                task.setPeriodUnit((PeriodUnit)(periodValue != null ? periodUnit : null));
                task.setSaveHistory(Boolean.valueOf(logHistory));
                task.setNext_run(nextRunDate);
                task.setStartingHour(startingHour);
                task.setEndingHour(endingHour);
                task.setMaxWorkingMinutes(maxWorkingMinutes);
                List<ScheduledTasksParametersTable> taskParametersDto = this.scheduledTaskParameterBuilder.buildTaskParameters(dtoParamList, task);
                for (ScheduledTasksParametersTable taskParameterDto : taskParametersDto) {
                    this.setEntityParameter(task, taskParameterDto);
                }
                task.getUserNotifications().clear();
                task.getUserNotifications().addAll(ListUtils.emptyIfNull((List)userNameNotifications).stream().map(x$0 -> this.userService.getUser(x$0, new String[0])).map(user -> ScheduledTaskUserNotification.builder().task(task).user(user).build()).collect(Collectors.toList()));
                task.getEmailNotifications().clear();
                task.getEmailNotifications().addAll(ListUtils.emptyIfNull((List)emailNotifications).stream().map(email -> ScheduledTaskEmailNotification.builder().task(task).email(email).build()).collect(Collectors.toList()));
                ScheduledTasksTableDAO.update((Session)session, (ScheduledTasksTable)task);
            }));
            ScheduledTasksTable task = ScheduledTasksTableDAO.get((Long)id);
            if (task.getIs_active().booleanValue()) {
                AbstractPeriodicTask periodicTask = this.periodicTaskResolver.getInstance(task);
                ScheduledTasksManager.getInstance().getScheduler().schedule(periodicTask);
            } else {
                ScheduledTasksManager.getInstance().getScheduler().delete(task.getId());
            }
            log.info("Zadanie zaplanowane zosta\u0142o zaktualizowane.");
            result.put("success", true);
            auditBuilder.success(true);
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (ScheduledTaskInvalidHoursRangeException e) {
            log.error(e.getMessage(), (Throwable)e);
            result.put("success", false);
            result.put("error", e.getLocalizedMessage());
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            result.put("success", false);
            ResponseEntity responseEntity = new ResponseEntity(result, (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        finally {
            auditBuilder.params(auditParamsBuilder.build()).build().log();
        }
    }

    private void setEntityParameter(ScheduledTasksTable taskEntity, ScheduledTasksParametersTable taskParameterDto) {
        Optional foundParameterEntity = this.scheduledTaskParameterFinder.findInEntity(taskEntity).by(taskParameterDto);
        if (foundParameterEntity.isPresent()) {
            ScheduledTasksParametersTable parameterEntity = (ScheduledTasksParametersTable)foundParameterEntity.get();
            parameterEntity.setParameter_value(taskParameterDto.getParameter_value());
        } else {
            taskEntity.getScheduled_tasks_parameters().add(taskParameterDto);
        }
    }
}

