/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.UserCalendar;
import com.suncode.pwfl.calendar.user.UserCalendarShare;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.calendar.user.api.UserCalendarShareService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.calendar.UserCalendarShareDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/user/{calendarId}/share"})
@Api(hidden=true)
public class UserCalendarShareController {
    private final UserCalendarShareService userCalendarShareService;
    private final CalendarMapper calendarMapper;
    private final UserService userService;
    private final UserCalendarService userCalendarService;

    @GetMapping
    public CountedResult<UserCalendarShareDto> getUserCalendarShares(@PathVariable long calendarId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        List<UserCalendarShareDto> userCalendarShares = this.userCalendarShareService.getUserCalendarSharesForCalendar(calendarId).stream().map(this.calendarMapper::toUserCalendarShareDto).toList();
        return Paginator.forAll(userCalendarShares).viewPageByOffset(start, limit);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public long addUserCalendarShare(@PathVariable long calendarId, @RequestBody UserCalendarShareDto userCalendarShareDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_USER_CALENDAR_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendarShare userCalendarShare = this.calendarMapper.toUserCalendarShare(userCalendarShareDto);
            userCalendarShare.setCalendarId(calendarId);
            auditParamsBuilder.params(this.paramsFromUserCalendarShare(userCalendarShare, user));
            long shareId = this.userCalendarShareService.addUserCalendarShare(userCalendarShare, user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return shareId;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{shareId}"})
    public RestResult deleteUserCalendarShare(@PathVariable long calendarId, @PathVariable long shareId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)shareId).param("calendarId", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_CALENDAR_SHARE);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            UserCalendar userCalendar = (UserCalendar)this.userCalendarService.getCalendar(Long.valueOf(calendarId), user);
            auditParamsBuilder.param("calendarName", (Object)userCalendar.getName());
            this.userCalendarShareService.deleteUserCalendarShare(Long.valueOf(shareId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    private Map<String, Object> paramsFromUserCalendarShare(UserCalendarShare userCalendarShare, User user) {
        UserCalendar userCalendar = (UserCalendar)this.userCalendarService.getCalendar(Long.valueOf(userCalendarShare.getCalendarId()), user);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("calendarId", (Object)userCalendarShare.getCalendarId()).param("calendarName", (Object)userCalendar.getName()).param("userName", (Object)userCalendarShare.getUserName()).param("groupName", (Object)userCalendarShare.getGroupName()).param("permissionLevel", (Object)userCalendarShare.getPermissionLevel().name());
        return auditParamsBuilder.build();
    }

    @ConstructorProperties(value={"userCalendarShareService", "calendarMapper", "userService", "userCalendarService"})
    @Autowired
    public UserCalendarShareController(UserCalendarShareService userCalendarShareService, CalendarMapper calendarMapper, UserService userService, UserCalendarService userCalendarService) {
        this.userCalendarShareService = userCalendarShareService;
        this.calendarMapper = calendarMapper;
        this.userService = userService;
        this.userCalendarService = userCalendarService;
    }
}

