/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.DefaultCalendar;
import com.suncode.pwfl.calendar.api.CalendarFacade;
import com.suncode.pwfl.calendar.defaultCalendar.api.DefaultCalendarService;
import com.suncode.pwfl.calendar.event.RecurrenceDefinition;
import com.suncode.pwfl.calendar.event.UserCalendarEvent;
import com.suncode.pwfl.calendar.resource.CalendarResource;
import com.suncode.pwfl.calendar.resource.CalendarResourceService;
import com.suncode.pwfl.calendar.user.UserCalendarEventParticipant;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.web.dto.calendar.event.UserCalendarEventDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.data.CalendarOutputter;
import org.dmfs.rfc5545.recur.InvalidRecurrenceRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"calendar/default"})
@Api(hidden=true)
public class DefaultCalendarController {
    private static final Logger log = LoggerFactory.getLogger(DefaultCalendarController.class);
    private final CalendarFacade calendarFacade;
    private final DefaultCalendarService defaultCalendarService;
    private final UserService userService;
    private final CalendarMapper calendarMapper;
    private final CalendarResourceService calendarResourceService;
    private final UserCalendarService userCalendarService;

    @GetMapping(value={"events"})
    public List<UserCalendarEventDto> getEventsForDefaultCalendar(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        return this.defaultCalendarService.getEventsForCalendarByInterval(user, fromDateTime, toDateTime).stream().map(event -> this.calendarMapper.toUserCalendarEventDto((UserCalendarEvent)event, user)).toList();
    }

    @PostMapping(value={"events"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserCalendarEventDto createEventForDefaultCalendar(@RequestBody UserCalendarEventDto userCalendarEventDto, HttpServletRequest request) throws InvalidRecurrenceRuleException {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_USER_CALENDAR_EVENT);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
            UserCalendarEvent userCalendarEvent = this.calendarMapper.toUserCalendarEvent(userCalendarEventDto);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(userCalendarEvent));
            UserCalendarEvent createdDefaultCalendarEvent = this.userCalendarService.createEvent(null, user, userCalendarEvent);
            auditParamsBuilder.params(this.paramsFromUserCalendarEvent(createdDefaultCalendarEvent));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toUserCalendarEventDto(createdDefaultCalendarEvent, user);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @Nullable
    @GetMapping(value={"share/link"})
    public String getCalendarShareLink() {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Calendar calendar = this.calendarFacade.getCalendarForUser((Calendar)new DefaultCalendar(user), user);
        return calendar.getShareLinkId() != null ? this.buildShareCalendarUrl(calendar.getShareLinkId()) : null;
    }

    @GetMapping(value={"share/link/generate"})
    public String generateCalendarShareLink(HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_GENERATE_USER_CALENDAR_SHARE_LINK).params(new AuditParamsBuilder().param("id", null).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            String shareLinkId = this.calendarFacade.generateCalendarShareLink((Calendar)new DefaultCalendar(user), user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return this.buildShareCalendarUrl(shareLinkId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"share/link"})
    public RestResult deleteCalendarShareLink(HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_USER_CALENDAR_SHARE_LINK).params(new AuditParamsBuilder().param("id", null).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.calendarFacade.deleteCalendarShareLink((Calendar)new DefaultCalendar(user), user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"share/link/{shareLinkId}"})
    public ResponseEntity<byte[]> getCalendarIcalResource(@PathVariable String shareLinkId) {
        net.fortuna.ical4j.model.Calendar icalCalendar = this.calendarFacade.buildIcalCalendar((Calendar)new DefaultCalendar(shareLinkId));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            outputter.output(icalCalendar, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error("Error on creating ICS file for resource " + shareLinkId, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        byte[] icalBytes = byteArrayOutputStream.toByteArray();
        String fileFormat = ".ics";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"text/calendar"));
        headers.setContentDispositionFormData("attachment", shareLinkId + ".ics");
        return new ResponseEntity((Object)icalBytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private String buildShareCalendarUrl(String shareLinkId) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/api/calendar/default/share/link/{shareLinkId}").buildAndExpand(new Object[]{shareLinkId}).toUriString();
    }

    private Map<String, Object> paramsFromUserCalendarEvent(UserCalendarEvent userCalendarEvent) {
        String recurrencePattern;
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("title", (Object)userCalendarEvent.getTitle()).param("description", (Object)userCalendarEvent.getDescription()).param("allDay", (Object)userCalendarEvent.isAllDay()).param("startDateTimeUTC", (Object)userCalendarEvent.getStartDateTimeUTC()).param("endDateTimeUTC", (Object)userCalendarEvent.getEndDateTimeUTC()).param("recurrent", (Object)(userCalendarEvent.getRecurrenceDefinition() != null ? 1 : 0)).param("participants", this.getParticipants(userCalendarEvent)).param("resources", (Object)this.getResources(userCalendarEvent)).param("timeZone", (Object)userCalendarEvent.getTimeZone());
        Integer durationMinutes = this.getDurationMinutes(userCalendarEvent);
        if (durationMinutes != null) {
            auditParamsBuilder.param("durationMinutes", (Object)durationMinutes);
        }
        if ((recurrencePattern = this.getRecurrencePattern(userCalendarEvent)) != null) {
            auditParamsBuilder.param("recurrencePattern", (Object)recurrencePattern);
        }
        return auditParamsBuilder.build();
    }

    private Integer getDurationMinutes(UserCalendarEvent userCalendarEvent) {
        return Optional.ofNullable(userCalendarEvent.getRecurrenceDefinition()).map(RecurrenceDefinition::durationMinutes).orElse(null);
    }

    private String getRecurrencePattern(UserCalendarEvent userCalendarEvent) {
        return Optional.ofNullable(userCalendarEvent.getRecurrenceDefinition()).map(RecurrenceDefinition::recurrencePattern).orElse(null);
    }

    private List<String> getParticipants(UserCalendarEvent userCalendarEvent) {
        return Optional.ofNullable(userCalendarEvent.getParticipants()).stream().flatMap(Collection::stream).map(UserCalendarEventParticipant::getUser).map(User::getUserName).toList();
    }

    private String getResources(UserCalendarEvent userCalendarEvent) {
        return ((List)Optional.ofNullable(userCalendarEvent.getResourceIds()).orElse(new ArrayList())).stream().map(resourceId -> {
            CalendarResource calendarResource = this.calendarResourceService.getCalendarResource(resourceId);
            return resourceId + ":" + calendarResource.getName();
        }).collect(Collectors.joining(","));
    }

    @ConstructorProperties(value={"calendarFacade", "defaultCalendarService", "userService", "calendarMapper", "calendarResourceService", "userCalendarService"})
    @Autowired
    public DefaultCalendarController(CalendarFacade calendarFacade, DefaultCalendarService defaultCalendarService, UserService userService, CalendarMapper calendarMapper, CalendarResourceService calendarResourceService, UserCalendarService userCalendarService) {
        this.calendarFacade = calendarFacade;
        this.defaultCalendarService = defaultCalendarService;
        this.userService = userService;
        this.calendarMapper = calendarMapper;
        this.calendarResourceService = calendarResourceService;
        this.userCalendarService = userCalendarService;
    }
}

