/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.ldap.LDAPManager;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.license.LicenseAccessor;
import com.suncode.pwfl.license.exceptions.TooManyUsersException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.administration.user.ImportLdapUsersDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"users/ldap"})
@Api(value="LDAP User Administration", tags={"users"})
public class LdapUserController {
    private static final Logger log = LoggerFactory.getLogger(LdapUserController.class);
    private final DomainService domainService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ApiOperation(value="(Admin) Importing users from ldap", notes="Imports users from ldap")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PostMapping(value={"import"})
    public RestResult importUsersFromLdap(HttpServletRequest request, @ApiParam(value="The executed query imports users from ldap. The query is a JSON object with the following fields \n          - **domainId** - id of the domain\n          - **dnPath** - base dn\n          - **importFilter** - import filter\n          - **defaultGroupNames** - group names which users will be added to, that cannot be assigned to another group, taking into account the configuration in the fields below\n          - **addToDefaultGroup** - users will be added to the specified default group\n          - **addToLdapGroup** - users will be added to the groups, that are assigned in the ldap\n          - **createNotExistingGroups** - (if addToLdapGroup = true) Non-existent groups in the system, that users have assigned in LDAP, will be created. If the option is not selected, the user will be added to the default group if there is no group in the system.", required=true) @RequestBody ImportLdapUsersDto importLdapUsersDto) {
        Assert.notNull((Object)importLdapUsersDto.getDomainId(), (String)this.messageHelper.getMessage("Nie_podano_id_domeny"));
        Domain domain = Optional.ofNullable(this.domainService.getDomain(importLdapUsersDto.getDomainId())).orElseThrow(() -> new ServiceException(this.messageHelper.getMessage("Domena_o_podanym_id_nie_istnieje", new Object[]{importLdapUsersDto.getDomainId()})));
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_USER_FROM_LDAP).params((Map)ImmutableMap.of((Object)"domainName", (Object)domain.getDomainName()));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        String groupNames = this.messageHelper.getMessage("Uzytkownicy_domenowi");
        if (importLdapUsersDto.getDefaultGroupNames() != null && !importLdapUsersDto.getDefaultGroupNames().isEmpty()) {
            groupNames = String.join((CharSequence)";", importLdapUsersDto.getDefaultGroupNames());
        }
        try {
            LDAPManager.addUsersFromLdap((String)domain.getDomainName(), (String)importLdapUsersDto.getDnPath(), (String)importLdapUsersDto.getImportFilter(), (String)groupNames, (boolean)importLdapUsersDto.isAddToDefaultGroup(), (boolean)importLdapUsersDto.isAddToLdapGroup(), (boolean)importLdapUsersDto.isCreateNotExistingGroups(), (boolean)false, (String)"admin", (String)"");
            request.setAttribute("audit", (Object)builder.buildSuccess());
            return new RestResult(true, this.messageHelper.getMessage("ldapImport.admin.success"));
        }
        catch (TooManyUsersException ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            log.warn("U\u017cytkownicy nie zostali zaimportowani. Licencja systemu nie pozwala na liczb\u0119 u\u017cytkownik\u00f3w powy\u017cej " + LicenseAccessor.getInstance().getMaxUsers());
            return new RestResult(false, this.messageHelper.getMessage("Licencja_systemu_nie_pozwala_na_liczbe_uzytkownikow_powyzej") + " " + LicenseAccessor.getInstance().getMaxUsers());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            log.error(ex.getMessage(), (Throwable)ex);
            return new RestResult(false, this.messageHelper.getMessage("ldapImport.admin.error"));
        }
    }

    @ConstructorProperties(value={"domainService", "authorizationHelper", "messageHelper"})
    @Autowired
    public LdapUserController(DomainService domainService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.domainService = domainService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

