/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.authentication.basic;

import com.google.common.collect.ImmutableMap;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.pwfl.administration.authentication.basic.BasicAuthenticationConfiguration;
import com.suncode.pwfl.administration.authentication.basic.BasicAuthenticationConfigurationException;
import com.suncode.pwfl.administration.authentication.basic.BasicAuthenticationConfigurationService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.web.dto.administration.authentication.basic.BasicAuthenticationConfigurationDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/authenticationManagement/basic"})
public class BasicAuthenticationConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthenticationConfigurationController.class);
    @Autowired
    private BasicAuthenticationConfigurationService basicAuthenticationConfigurationService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    private List<BasicAuthenticationConfigurationDto> getAll(@RequestParam(required=false, defaultValue="name") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Sorter sorter = new Sorter(orderBy, orderDirection);
        return this.basicAuthenticationConfigurationService.getAll(sorter).stream().map(BasicAuthenticationConfigurationDto::new).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={""})
    private BasicAuthenticationConfigurationDto create(@RequestBody BasicAuthenticationConfigurationDto basicAuthenticationConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_BASIC_AUTHENTICATION_CONFIGURATION).params(this.getAuditParams(basicAuthenticationConfigurationDto));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            BasicAuthenticationConfiguration basicAuthenticationConfiguration = basicAuthenticationConfigurationDto.toEntity();
            this.basicAuthenticationConfigurationService.save((Object)basicAuthenticationConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new BasicAuthenticationConfigurationDto(basicAuthenticationConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    private BasicAuthenticationConfigurationDto getById(@PathVariable String id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        BasicAuthenticationConfiguration basicAuthenticationConfiguration = (BasicAuthenticationConfiguration)this.basicAuthenticationConfigurationService.get((Serializable)((Object)id));
        return new BasicAuthenticationConfigurationDto(basicAuthenticationConfiguration);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.PATCH}, value={""})
    private BasicAuthenticationConfigurationDto update(@RequestBody BasicAuthenticationConfigurationDto basicAuthenticationConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_BASIC_AUTHENTICATION_CONFIGURATION);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", Objects.toString(basicAuthenticationConfigurationDto.getId(), ""));
        auditBuilder.params(params);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            BasicAuthenticationConfiguration oldConfiguration = (BasicAuthenticationConfiguration)this.basicAuthenticationConfigurationService.get((Serializable)((Object)basicAuthenticationConfigurationDto.getId()));
            BasicAuthenticationConfiguration newConfiguration = basicAuthenticationConfigurationDto.toEntity();
            params.putAll(this.getUpdateAuditParams(oldConfiguration, newConfiguration));
            auditBuilder.params(params);
            this.basicAuthenticationConfigurationService.update((Object)newConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new BasicAuthenticationConfigurationDto(newConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    private void delete(@PathVariable String id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_BASIC_AUTHENTICATION_CONFIGURATION).params((Map)ImmutableMap.of((Object)"id", (Object)id));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            BasicAuthenticationConfiguration basicAuthenticationConfiguration = (BasicAuthenticationConfiguration)this.basicAuthenticationConfigurationService.get((Serializable)((Object)id));
            this.basicAuthenticationConfigurationService.delete((Object)basicAuthenticationConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    private Map<String, Object> getAuditParams(BasicAuthenticationConfigurationDto basicAuthenticationConfigurationDto) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("id", Objects.toString(basicAuthenticationConfigurationDto.getId(), ""));
        params.put("name", Objects.toString(basicAuthenticationConfigurationDto.getName(), ""));
        params.put("username", Objects.toString(basicAuthenticationConfigurationDto.getUsername(), ""));
        return params;
    }

    private Map<String, Object> getUpdateAuditParams(BasicAuthenticationConfiguration oldConfiguration, BasicAuthenticationConfiguration newConfiguration) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("name", this.getChangeString(oldConfiguration, newConfiguration, BasicAuthenticationConfiguration::getName));
        params.put("username", this.getChangeString(oldConfiguration, newConfiguration, BasicAuthenticationConfiguration::getUsername));
        return params;
    }

    private String getChangeString(BasicAuthenticationConfiguration oldConfiguration, BasicAuthenticationConfiguration newConfiguration, Function<BasicAuthenticationConfiguration, Object> valueFunction) {
        String oldValue = Objects.toString(valueFunction.apply(oldConfiguration), "");
        String newValue = Objects.toString(valueFunction.apply(newConfiguration), "");
        return String.format("%s;%s", oldValue, newValue);
    }

    @ExceptionHandler(value={BasicAuthenticationConfigurationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleConfigurationException(BasicAuthenticationConfigurationException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }
}

