/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller;

import com.plusmpm.database.authorization.Right;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.authorization.RightsManager;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rights"})
@Api(tags={"others"})
public class RightsController {
    @Autowired
    DocumentClassService documentClassService;
    @Autowired
    LinkService linkService;
    @Autowired
    ProcessService ps;
    @Autowired
    HibernateTransactionManager htm;

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"documentclass/{documentClassId}/release/archive"})
    public Boolean hasDocumentClass(@PathVariable Long documentClassId) {
        String userName = SessionUtils.getLoggedUserName();
        String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).release().archive().build();
        int rights = Authorization.checkRight((String)rightLevel, (String)userName, (boolean)false, (boolean)false);
        return rights != -1;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"documentclass/{documentClassId}/modify"})
    public Boolean hasDocumentClassModifyRights(@PathVariable Long documentClassId) {
        String userName = SessionUtils.getLoggedUserName();
        String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).modify().build();
        int rights = Authorization.checkRight((String)rightLevel, (String)userName, (boolean)false, (boolean)false);
        return rights != -1;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"documentclass/{documentClassId}/delete"})
    public Boolean hasDocumentClassDeleteRights(@PathVariable Long documentClassId) {
        String userName = SessionUtils.getLoggedUserName();
        String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).delete().build();
        int rights = Authorization.checkRight((String)rightLevel, (String)userName, (boolean)false, (boolean)false);
        return rights != -1;
    }

    @ApiOperation(value="Downloading information about authority levels", notes="Returns a list of permissions to processes (system.workflow.processes level), to archive documents (system.archive.docclasses level), to archive document sets ('system.archive.links level). <br>", nickname="others")
    @ResponseBody
    @GetMapping(value={"partial"})
    public List<PartialRightDto> checkPartialRights(@ApiParam(value="User or user group name", required=true) @RequestParam String resourceName, @ApiParam(value="If true, the resourceName parameter contains the group name, if false it contains the user name", required=true) @RequestParam Boolean isGroup) {
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)this.htm);
        return (List)tt.execute(status -> {
            PartialRightDto partialRight;
            Session session = this.htm.getSessionFactory().getCurrentSession();
            List dcRights = RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().archive().docClasses().custom((Object)"").build());
            List linksRights = RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().archive().links().custom((Object)"").build());
            ArrayList<Right> processesRights = new ArrayList<Right>();
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().delete().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().stats().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().history().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().historyComments().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().processDashboard().custom((Object)"").build()));
            processesRights.addAll(RightsManager.getRightHierarchy((Session)session, (String)resourceName, (boolean)isGroup, (String)RightTreeBuilder.builder().system().workflow().processes().processVisibility().custom((Object)"").build()));
            ArrayList<PartialRightDto> partialRights = new ArrayList<PartialRightDto>();
            if (CollectionUtils.isNotEmpty((Collection)dcRights)) {
                partialRight = new PartialRightDto();
                partialRight.setSection("docclasses");
                partialRight.setDetails(this.getDocumentClassesName(dcRights));
                partialRights.add(partialRight);
            }
            if (CollectionUtils.isNotEmpty((Collection)linksRights)) {
                partialRight = new PartialRightDto();
                partialRight.setSection("links");
                partialRight.setDetails(this.getLinksName(linksRights));
                partialRights.add(partialRight);
            }
            if (CollectionUtils.isNotEmpty(processesRights)) {
                partialRight = new PartialRightDto();
                partialRight.setSection("processes");
                partialRight.setDetails(this.getProcessesName(processesRights));
                partialRights.add(partialRight);
            }
            return partialRights;
        });
    }

    private List<String> getDocumentClassesName(List<Right> docClassesRights) {
        ArrayList<String> dcNames = new ArrayList<String>();
        for (Right right : docClassesRights) {
            DocumentClass documentClass;
            String level = right.getLevel();
            String[] parts = level.split("\\.");
            if (parts.length != 4 || (documentClass = (DocumentClass)this.documentClassService.get((Serializable)Long.valueOf(parts[3]))) == null) continue;
            dcNames.add(this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME));
        }
        return dcNames;
    }

    private List<String> getLinksName(List<Right> linksRights) {
        ArrayList<String> linkNames = new ArrayList<String>();
        for (Right right : linksRights) {
            Link link;
            String level = right.getLevel();
            String[] parts = level.split("\\.");
            if (parts.length != 4 || (link = (Link)this.linkService.get((Serializable)Long.valueOf(parts[3]))) == null) continue;
            linkNames.add(this.linkService.getLinkTranslation(link.getId(), TranslatedFieldType.NAME));
        }
        return linkNames;
    }

    private List<String> getProcessesName(List<Right> linksRights) {
        I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
        HashMap<String, String> processes = new HashMap<String, String>();
        for (Right right : linksRights) {
            ProcessDefinition pd;
            String processDefId;
            String level = right.getLevel();
            String[] parts = level.split("\\.");
            if (parts.length != 5 || processes.containsKey(processDefId = parts[4]) || (pd = this.ps.getProcessDefinition(processDefId)) == null) continue;
            processes.put(processDefId, xpdl.getString(XpdlKey.forPackage((String)pd.getPackageId()).forProcess(processDefId).getKey()));
        }
        return new ArrayList<String>(processes.values());
    }

    class PartialRightDto {
        private String section;
        private List<String> details;

        PartialRightDto() {
        }

        public String getSection() {
            return this.section;
        }

        public List<String> getDetails() {
            return this.details;
        }

        public void setSection(String section) {
            this.section = section;
        }

        public void setDetails(List<String> details) {
            this.details = details;
        }
    }
}

