/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.servlet;

import com.suncode.pwfl.license.InternalLicenseService;
import com.suncode.pwfl.license.LicenseFile;
import com.suncode.pwfl.license.TempLicenseFile;
import com.suncode.pwfl.util.SpringContext;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LicenseLoad
extends HttpServlet {
    private static final Logger log = Logger.getLogger(LicenseLoad.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute("username") != null) {
            try {
                response.setContentType("text/html");
                response.setCharacterEncoding("UTF-8");
                boolean isLicenseLoaded = this.saveLicense();
                if (isLicenseLoaded) {
                    request.setAttribute("auditSuccess", (Object)true);
                    response.getWriter().write("{success:true}");
                } else {
                    response.getWriter().write("{success:false}");
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                response.getWriter().write("{success:false,msg:\"" + e.getMessage() + "; " + (e.getCause() != null ? e.getCause().getMessage() : "") + "\"}");
            }
        }
    }

    private boolean saveLicense() {
        try {
            TempLicenseFile tlf = TempLicenseFile.getInstance();
            LicenseFile license = new LicenseFile(tlf.getLicenseData(), tlf.getPublicKey());
            InternalLicenseService licenseService = (InternalLicenseService)SpringContext.getBean((String)"internalLicenseService");
            licenseService.saveLicense(license);
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

