/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.virtualtables;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.plusmpm.database.virtualtables.ModifiedJSON;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.plusmpm.util.virtualtables.MyIdExistsException;
import com.plusmpm.util.virtualtables.ObslugaZmian;
import com.plusmpm.util.virtualtables.ObslugaZmianKolumny;
import com.plusmpm.util.virtualtables.ObslugaZmianTabele;
import com.plusmpm.util.virtualtables.ObslugaZmianWartosci;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VRecord;
import com.plusmpm.util.virtualtables.VTable;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

public class setJsonChanges
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(setJsonChanges.class);
    protected String type;
    protected String tableId;
    protected String[] deleted;
    protected ArrayList<Hashtable<String, String>> modified;
    protected ObslugaZmian modifiedProcessor;
    protected int numberOfModified = 0;
    protected int numberOfDeleted = 0;
    String userId;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.userId = String.valueOf(request.getSession().getAttribute("username"));
        response.setContentType("text/html");
        this.type = request.getParameter("type");
        String jsonString = request.getParameter("jsonString");
        log.info((Object)("zaczynam parsowanie json stringa ze zmianami: " + jsonString));
        if (this.parseJsonString(jsonString)) {
            log.info((Object)"zaczynam wprowadza\u0107 zmiany");
            String summary = this.processRequestedChanges(this.type, this.tableId, this.deleted, this.modified);
            response.getWriter().write(summary);
        } else {
            response.getWriter().write("{result : PW.t('porazka'), msg : PW.t('bad_json_changes')");
            log.error((Object)"zly JSONString ze zmianami");
        }
    }

    private String getSummaryString() {
        String message = this.createChangesDoneMessage(this.type, this.numberOfModified, this.numberOfDeleted);
        if (StringUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        return "{result : PW.t('uwaga'), msg : '" + message + "'}";
    }

    public String createChangesDoneMessage(String type, Integer modificated, Integer deleted) {
        StringBuilder builder = new StringBuilder();
        builder.append("<b>");
        if (type.compareTo("tablesGrid") == 0) {
            builder.append(MessageHelper.getMessage((String)"zapisanoTabele"));
        } else if (type.compareTo("columnsGrid") == 0) {
            builder.append(MessageHelper.getMessage((String)"zapisanoKolumny"));
        } else if (type.compareTo("valuesGrid") == 0) {
            builder.append(MessageHelper.getMessage((String)"zapisanoWartosci"));
        } else {
            return null;
        }
        builder.append("</b></br>");
        builder.append("<table>");
        builder.append("<tr><td align=\"right\">");
        builder.append(MessageHelper.getMessage((String)"zmodyfikowanychRekordow"));
        builder.append(": </td><td>");
        builder.append(modificated);
        builder.append("</td></tr>");
        builder.append("<tr><td align=\"right\">");
        builder.append(MessageHelper.getMessage((String)"usunietychRekordow"));
        builder.append(": </td><td>");
        builder.append(deleted);
        builder.append("</td></tr>");
        builder.append("</table>");
        return builder.toString();
    }

    public boolean parseJsonString(String jsonString) {
        Gson gson = GsonFactory.getGson();
        ModifiedJSON mJsonData = null;
        try {
            mJsonData = (ModifiedJSON)gson.fromJson(jsonString, ModifiedJSON.class);
        }
        catch (JsonParseException jpe) {
            this.badJsonError(jsonString);
            log.error((Object)jpe.getMessage(), (Throwable)jpe);
            return false;
        }
        this.type = mJsonData.getType();
        this.tableId = mJsonData.getTableId();
        this.deleted = mJsonData.getDeleted();
        this.parseModified(mJsonData.getModified());
        return true;
    }

    protected String processRequestedChanges(String type, String tableId, String[] del, ArrayList<Hashtable<String, String>> modified) {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            if (type.compareTo("tablesGrid") == 0) {
                this.numberOfDeleted = VTable.delete((String[])del);
                this.modifiedProcessor = new ObslugaZmianTabele(modified, tableId, this.userId);
            }
            if (type.compareTo("columnsGrid") == 0) {
                this.numberOfDeleted = VColumn.delete((String)tableId, (String[])del);
                this.modifiedProcessor = new ObslugaZmianKolumny(modified, tableId, this.userId);
            }
            if (type.compareTo("valuesGrid") == 0) {
                this.numberOfDeleted = VRecord.delete((String)tableId, (String[])del);
                this.modifiedProcessor = new ObslugaZmianWartosci(modified, tableId, this.userId);
            }
        });
        return (String)TransactionWrapper.get().doInHibernateTransaction(session -> {
            Object result = null;
            try {
                this.numberOfModified = this.modifiedProcessor.process();
                result = this.getSummaryString();
            }
            catch (MyIdExistsException miee) {
                result = "{result : PW.t('porazka'), msg : PW.t('zduplikowany') + '" + miee.objectId + "'}";
            }
            catch (HibernateException he) {
                log.info((Object)he.getMessage(), (Throwable)he);
                result = "{result : PW.t('porazka'), msg : PW.t('bladBazy')}";
            }
            return result;
        });
    }

    protected void processDeletedColumns(String[] del) {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            for (int i = 0; i < del.length; ++i) {
                VColumn.delete((String)this.tableId, (String)del[i]);
                ++this.numberOfDeleted;
            }
        });
    }

    private void parseModified(List<Map<String, String>> list) {
        this.modified = new ArrayList();
        Hashtable<String, String> hashtable = null;
        int ile = list.size();
        for (int i = 0; i < ile; ++i) {
            hashtable = new Hashtable<String, String>(list.get(i));
            this.modified.add(hashtable);
        }
    }

    protected void badJsonError(String jsonString) {
        Object str = "otrzymano z\u0142y format w JsonStringu danych zmodyfikowanych:";
        str = (String)str + "\n";
        str = (String)str + "\t" + jsonString;
        log.error(str);
    }

    public String getType() {
        return this.type;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String[] getDeleted() {
        return this.deleted;
    }

    public ArrayList<Hashtable<String, String>> getModified() {
        return this.modified;
    }
}

