/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.packages;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.plusmpm.servlet.packages.PackageTreeNode;
import com.plusmpm.servlet.packages.PackageVersionTreeNode;
import com.plusmpm.servlet.packages.TreeNode;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.enhydra.shark.Shark;

public class PackageInformationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String node = request.getParameter("node");
        String returnJson = null;
        if (node.equals("root")) {
            returnJson = this.getRootPackagesJson();
        } else {
            TreeNode.TreeNodeType packageType = TreeNode.TreeNodeType.valueOf(request.getParameter("type"));
            if (packageType.equals((Object)TreeNode.TreeNodeType.PACKAGE)) {
                returnJson = this.getPackageVersionsJson(node);
            }
        }
        if (returnJson != null) {
            response.getWriter().write(returnJson);
        }
    }

    public String getRootPackagesJson() {
        List packagesId = XpdlPackageManager.getInstance().getPackageIds();
        ArrayList<PackageTreeNode> packagesNodes = new ArrayList<PackageTreeNode>();
        for (String packageId : packagesId) {
            PackageTreeNode node = new PackageTreeNode(packageId, packageId, false);
            packagesNodes.add(node);
        }
        Gson gson = GsonFactory.getGson();
        Type collectionType = new TypeToken<List<PackageTreeNode>>(){}.getType();
        return gson.toJson(packagesNodes, collectionType);
    }

    private String getPackageVersionsJson(String packageId) {
        ArrayList<PackageVersionTreeNode> packageVersions = new ArrayList<PackageVersionTreeNode>();
        for (String packageVersion : Shark.getInstance().getAdminInterface().getPackageAdministration().getXMLInterface().getAllPackageVersions(packageId)) {
            String id = packageId + "_" + packageVersion;
            String displayText = packageId + " ver: " + packageVersion;
            PackageVersionTreeNode node = new PackageVersionTreeNode(id, displayText, true, packageId, Long.valueOf(packageVersion));
            packageVersions.add(node);
        }
        Collections.sort(packageVersions, new Comparator<PackageVersionTreeNode>(){

            @Override
            public int compare(PackageVersionTreeNode o1, PackageVersionTreeNode o2) {
                return o2.getVersion().compareTo(o1.getVersion());
            }
        });
        Gson gson = GsonFactory.getGson();
        Type collectionType = new TypeToken<List<PackageVersionTreeNode>>(){}.getType();
        return gson.toJson(packageVersions, collectionType);
    }
}

