jQuery(document).ready(function() {
	initSelectizeInput();
});

function initSelectizeInput(){
	PW.ui.Selectize.initInput('.selectizeInput', {
		plugins : {
			'preserve_search' : {},
			'create_on_enter_or_delimeter' : {}
		}
	});
}

Selectize.define('preserve_search', function(options) {
	var self = this;

	options.text = options.text || function(option) {
		return option[this.settings.labelField];
	};

	this.onBlur = (function(e) {
		var original = self.onBlur;

		return function(e) {
			var $input = this.$control_input;
			var inputId = $input[0].id;
			var inputValue = $input.val();

			if (inputValue != "") {
				/*
				 * potrzebne opóźnienie żeby document.activeElement wskazywał na
				 * nowy element (w momencie blura jeszcze wskazuje na stary)
				 * opoznienie nie może być zbyt duże, ponieważ szybki dwuklik
				 * zrobi focus na body
				 */
				setTimeout(checkAndConfirmValueInSelectizeInput, 10, this, inputId);
				this.setTextboxValue(inputValue);
			} else {
				original.apply(this, [ e ]);
			}
		};
	})();
});

var checkAndConfirmValueInSelectizeInput = function(input, inputId) {
	var target = document.activeElement;

	var mainInputId = inputId.replace('-selectized', '');
	var myTriggerClicked = target.id == mainInputId + '-textHelper';

	if (!myTriggerClicked && !myTextHelperVisible(mainInputId)) {
	    PW.ui.Selectize._addValueToInput(input);
	}
}



function myTextHelperVisible(inputId) {
	// sprawdza czy wyświetlany textHelper jest powiązany z inputId
	var extHelper = Ext.getCmp('advanceSearchTextHelper');
	if (extHelper == undefined || extHelper.hidden) {
		return false;
	} else {
		// helper widoczny
		var helperTargetInputId = extHelper.targetInput.id;
		if (helperTargetInputId == inputId) {
			return true;
		} else {
			return false;
		}
	}
}

Selectize.define('create_on_enter_or_delimeter',
		function() {
			if (this.settings.mode !== 'multi')
				return;
			var self = this;
			this.onKeyUp = (function(e) {
				var original = self.onKeyUp;
				return function(e) {
					if (e.which != 0)
					{
						if ((e.keyCode === 13 || e.keyCode === 186 || String.fromCharCode(e.which) === ';')
								&& this.$control_input.val().trim() != '') {
							if (this.$control_input.val().trim() == ';') {
								this.$control_input.val('');
								return;
							}
							
							PW.ui.Selectize._addValueToInput(this);
							
						} else if (e.keyCode === 13) {
							jQuery('#varForm').submit();
						}
					}
				}
			})();
		})
