Ext4.define('Suncode.passwordpolicy.view.form.ProfileConfigurationForm', {
	extend: 'Ext.panel.Panel',

	alias: 'widget.passwordpolicy-profileconfigurationform',

	bodyStyle: {
		border: 'none'
	},

	items: [{
		name: 'profileKey',
		fieldLabel: PW.t('Klucz_profilu'),
		xtype: 'textfield',
		allowBlank: false
	}, {
		name: 'changePasswordTime',
		fieldLabel: PW.t('Okres_wymuszania_zmiany_hasla'),
		xtype: 'numberfield',
		emptyText: PW.t('Brak_wymuszania'),
		minValue: 1
	}, {
		name: 'minPasswordLength',
		fieldLabel: PW.t('Minimalna_dlugosc_hasla'),
		xtype: 'numberfield',
		allowBlank: false,
		minValue: 4,
		maxValue: 20
	}, {
		name: 'maxPasswordLength',
		fieldLabel: PW.t('Maksymalna_dlugosc_hasla'),
		xtype: 'numberfield',
		allowBlank: false,
		minValue: 4,
		maxValue: 64
	}, {
		name: 'requireVariableLetterSize',
		fieldLabel: PW.t('Wymagaj_wielkich_i_malych_liter'),
		xtype: 'checkbox'
	}, {
		name: 'requireNumbers',
		fieldLabel: PW.t('Wymagaj_cyfr'),
		xtype: 'checkbox'
	}, {
		name: 'requireSpecialCharacters',
		fieldLabel: PW.t('Wymagaj_znakow_specjalnych'),
		xtype: 'checkbox'
	}, {
		name: 'numberOfRememberedBackPasswords',
		fieldLabel: PW.t('Liczba_zapamietywanych_hasel_wstecz'),
		xtype: 'numberfield',
		emptyText: PW.t('Zapamietuj_wszystkie'),
		minValue: 1
	}, {
		name: 'blockAfterLoginAttempts',
		fieldLabel: PW.t('Liczba_prob_po_jakiej_uzytkownik_zostanie_tymczasowo_zablokowany'),
		xtype: 'numberfield',
		emptyText: PW.t('Brak_blokowania'),
		minValue: 1
	}, {
		name: 'unblockAfter',
		fieldLabel: PW.t('Odblokuj_uzytkownika_po_czasie'),
		xtype: 'numberfield',
		emptyText: PW.t('Nie_odblokowuj'),
		minValue: 1
	}, {
		name: 'sendUnblockingEmail',
		fieldLabel: PW.t('Wyslij_mail_odblokowujacy'),
		xtype: 'checkbox'
	}, {
		name: 'forcePassChange',
		fieldLabel: PW.t('Wymus_zmiane_hasla_pierwsze_logowanie'),
		xtype: 'checkbox'
	}, {
		name: 'allowUniversalPasswordLogin',
		fieldLabel: PW.t('Zezwol_na_logowanie_haslem_uniwersalnym'),
		xtype: 'checkbox'
	},
		{
			name: 'checkPasswordAgainstDictionary',
			fieldLabel: PW.t('Sprawdz_haslo_pod_katem_ataku_slownikowego'),
			xtype: 'checkbox'
		}]
});
