Ext.namespace('Ext.ux.plusmpm');

Ext.ux.plusmpm.DescriptionIcon = function(config){
	
	this.variableConfig = config;
	
	config = Ext.apply({
		autoEl: {
			tag: 'img',
			src: this.iconUrl
		}
	}, config);
	
	Ext.ux.plusmpm.DescriptionIcon.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.FileViewer


Ext.extend(Ext.ux.plusmpm.DescriptionIcon, Ext.Component, {
	
	iconUrl: 'pages/images/tooltip.png',
	
	onAfterRender: function(){
		var el = this.getEl();
		
		this.tooltip = new Ext.ux.plusmpm.DescriptionToolTip(Ext.apply({
				target: el
		},
		this.variableConfig));
	},
	
    initComponent : function(){
    	Ext.ux.plusmpm.DescriptionIcon.superclass.initComponent.call(this);
    	
    	this.on('afterrender', this.onAfterRender, this);
    }

}); // end of Ext.extend

Ext.ux.plusmpm.DescriptionToolTip = function(config){
	
	config = Ext.apply({
		dismissDelay	: 0,
	    showDelay		: 500
	}, config);
	
	Ext.ux.plusmpm.DescriptionToolTip.superclass.constructor.call(this, config);
}; //End of Ext.ux.plusmpm.DescriptionToolTip

Ext.extend(Ext.ux.plusmpm.DescriptionToolTip, Ext.ToolTip, {

	maxWidth: 500,
	
	isMouseOverBody : false,
	
    initComponent : function(){
    	this.on('afterrender', function() {
    		this.body.on('mouseenter', this.onMouseEnter, this);
    		this.body.on('mouseleave', this.onMouseLeave, this);
    	}
    	, this);
    	Ext.ux.plusmpm.DescriptionToolTip.superclass.initComponent.call(this);
        this.initClickTarget(this.target);
    },

    onTargetClick : function(){
    	if(this.hidden)
    		this.show();
    },

    onDocMouseDown : function(e){
    	if(!e.within(this.target.dom) && this.target.dom != e.target)
    		Ext.ux.plusmpm.DescriptionToolTip.superclass.onDocMouseDown.call(this, e);
    },
    
    onMouseLeave : function(e) {
    	this.isMouseOverBody = false;
    	this.delayHide();
    },
    
    onMouseEnter : function(e){
    	this.isMouseOverBody = true;
    },    

    hide : function(){
    	if(!this.isMouseOverBody)
    	{
    		Ext.ux.plusmpm.DescriptionToolTip.superclass.hide.call(this);
    	}
    	else
    	{
    		this.hideTimer = null;
    	}

    },

    
	initClickTarget : function(target){
		 var t;
	        if((t = Ext.get(target))){
	            if(this.target){
	                var tg = Ext.get(this.target);
	                this.mun(tg, 'click', this.onTargetClick, this);
	            }
	            this.mon(t, {
	                click: this.onTargetClick,
	                scope: this
	            });
	            
	            this.target = t;
	        }
	}
}); // end of Ext.extend
