(function (Ext) {
  Ext.define('Favourites.settings.view.FavouriteSets', {
    extend: 'Ext.grid.Panel',
    xtype: 'favourites-sets',

    requires: ['Favourites.settings.view.NewSetToolbar'],

    title: Favourites.I18N.m('settings.sets'),
    allowDeselect: true,
    autoScroll: true,

    initComponent: function () {
      var me = this,
        store = Ext.StoreManager.get('Favourites.store.FavouritesSets');

      Ext.apply(me, {
        store: store,
        columns: {
          defaults: {
            draggable: false,
            hideable: false,
          },
          items: [
            {
              xtype: 'rownumberer',
              width: 23,
            },
            {
              text: Favourites.I18N.m('name'),
              dataIndex: 'name',
              minWidth: 150,
              maxWidth: 400,
              flex: 1,
            },
            {
              text: Favourites.I18N.m('description'),
              dataIndex: 'description',
              minWidth: 150,
              maxWidth: 400,
              flex: 3,
            },
            {
              xtype: 'actioncolumn',
              tooltip: Favourites.I18N.m('delete'),
              width: 24,
              iconCls: 'dvnt-icon-x-circle',
              menuDisabled: true,
              sortable: false,
              resizable: false,
              handler: Ext.bind(me.handleDelete, me),
            },
          ],
        },
        dockedItems: [
          {
            xtype: 'favourites-settoolbar',
            dock: 'top',
          },
        ],
      });

      me.callParent(arguments);
    },

    handleDelete: function () {
      // 5 argument - rekord
      this.fireEvent('deleteSet', arguments[5]);
    },
  });
})(window.Ext4);
