<%@page import="com.suncode.pwfl.util.SpringContext"%>
<%@page import="com.suncode.pwfl.administration.configuration.DefinedSystemParameter"%>
<%@page import="com.suncode.pwfl.administration.configuration.SystemProperties"%>


<%@page import="com.suncode.pwfl.i18n.MessageHelper"%>
<%@page import="com.suncode.pwfl.administration.configuration.SystemType"%>
<%@page import="com.suncode.pwfl.license.trial.service.TrialService"%>
<%@ page import="org.apache.commons.lang3.StringUtils" %>


<%
	TrialService trialService = SpringContext.getBean( TrialService.class );
	String systemTypeValue = SystemProperties.getString( DefinedSystemParameter.SYSTEM_TYPE );
	SystemType systemType = SystemType.fromString( systemTypeValue );
	String systemName = SystemProperties.getString( DefinedSystemParameter.SYSTEM_NAME );

	boolean showVersion = trialService.readLicense().isValid() || systemType != SystemType.PRODUCTION;

	if ( showVersion || StringUtils.isNotBlank( systemName ) )
	{
		StringBuilder barBuilder = new StringBuilder();
		if ( StringUtils.isNotBlank( systemName ) )
		{
			barBuilder.append( systemName );
		}

		if ( StringUtils.isNotBlank( systemName ) && showVersion )
		{
			barBuilder.append( " - " );
		}

		if ( trialService.readLicense().isValid() )
		{
			barBuilder.append( MessageHelper.getMessage( "demoVersion" ) );
		}
		else if ( systemType != SystemType.PRODUCTION )
		{
			barBuilder.append( MessageHelper.getMessage( systemType.getMessageKey() ) );
		}
		%>
		<div class="system-type-text">
			<div class=${param.trialServiceStyleClassName}>
				<%=barBuilder.toString()%>
			</div>
		</div>
		<%
	}
%>