/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpHeaderSecurity
extends OncePerRequestFilter {
    private static final List<String> EXCLUDED_API_PATHS = new ArrayList<String>(List.of("/authentication/sso/login", "/authentication/sso/logout"));

    protected void doFilterInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws ServletException, IOException {
        String permissionsPolicy;
        String strictTransportSecurity;
        String referrerPolicy;
        String contentSecurityPolicy;
        if (!SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_SAMEORIGIN_DISABLED).booleanValue()) {
            httpResponse.setHeader("X-Frame-Options", "SAMEORIGIN");
        }
        if (StringUtils.isNotBlank((CharSequence)(contentSecurityPolicy = this.getContentSecurityPolicy(httpRequest)))) {
            httpResponse.setHeader("Content-Security-Policy", contentSecurityPolicy);
        }
        if (!SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_NOSNIFF_DISABLED).booleanValue()) {
            httpResponse.setHeader("X-Content-Type-Options", "nosniff");
        }
        if (StringUtils.isNotBlank((CharSequence)(referrerPolicy = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_REFERRER_POLICY)))) {
            httpResponse.setHeader("Referrer-Policy", referrerPolicy);
        }
        if (StringUtils.isNotBlank((CharSequence)(strictTransportSecurity = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_STRICT_TRANSPORT_SECURITY)))) {
            httpResponse.setHeader("Strict-Transport-Security", strictTransportSecurity);
        }
        if (StringUtils.isNotBlank((CharSequence)(permissionsPolicy = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTP_HEADER_SECURITY_PERMISSIONS_POLICY)))) {
            httpResponse.setHeader("Permissions-Policy", permissionsPolicy);
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private String getContentSecurityPolicy(HttpServletRequest httpRequest) {
        boolean isApiRequest = "/api".equals(httpRequest.getServletPath());
        boolean isExcludedPath = httpRequest.getPathInfo() != null && this.isPathExcluded(httpRequest.getPathInfo());
        DefinedSystemParameter parameterKey = isApiRequest && !isExcludedPath ? DefinedSystemParameter.HTTP_REST_HEADER_SECURITY_CONTENT_SECURITY_POLICY : DefinedSystemParameter.HTTP_HEADER_SECURITY_CONTENT_SECURITY_POLICY;
        return SystemProperties.getString((DefinedSystemParameter)parameterKey);
    }

    private boolean isPathExcluded(String path) {
        return EXCLUDED_API_PATHS.stream().anyMatch(path::startsWith);
    }
}

