/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

public class LinkIndexDto {
    private Long id;
    private Long linkId;
    private String indexName;
    private String translatedIndexName;
    private String indexDescription;
    private String indexType;
    private String indexTypeName;
    private String indexValues;
    private Long indexOrder;

    public String[] getValues() {
        if (this.indexValues == null) {
            return new String[0];
        }
        String[] values = this.indexValues.split("\n");
        if (values.length <= 1) {
            values = this.indexValues.split(",");
        }
        return values;
    }

    public static LinkIndexDto from(LinkIndex linkIndex) {
        LinkService linkService = ServiceFactory.getLinkService();
        return LinkIndexDto.builder().id(linkIndex.getId()).linkId(linkIndex.getLink().getId()).indexName(linkIndex.getName()).translatedIndexName(linkService.getLinkIndexTranslation(linkIndex.getId(), TranslatedFieldType.NAME)).indexDescription(StringUtils.defaultString((String)linkIndex.getDescription())).indexType(linkIndex.getType()).indexTypeName(linkIndex.getIndexTypeName()).indexValues(linkIndex.getValues()).indexOrder(linkIndex.getOrder()).build();
    }

    public static LinkIndex toEntity(LinkIndexDto dto, Long linkId) {
        LinkService linkService = ServiceFactory.getLinkService();
        return LinkIndex.builder().id(dto.getId()).link(linkService.getLink(linkId, new String[0])).name(dto.getIndexName().trim()).description(dto.getIndexDescription().trim()).type(dto.getIndexType()).values(dto.getIndexValues().trim()).order(dto.getIndexOrder()).build();
    }

    public static LinkIndexDtoBuilder builder() {
        return new LinkIndexDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getLinkId() {
        return this.linkId;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTranslatedIndexName() {
        return this.translatedIndexName;
    }

    public String getIndexDescription() {
        return this.indexDescription;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public String getIndexTypeName() {
        return this.indexTypeName;
    }

    public String getIndexValues() {
        return this.indexValues;
    }

    public Long getIndexOrder() {
        return this.indexOrder;
    }

    public LinkIndexDto() {
    }

    @ConstructorProperties(value={"id", "linkId", "indexName", "translatedIndexName", "indexDescription", "indexType", "indexTypeName", "indexValues", "indexOrder"})
    public LinkIndexDto(Long id, Long linkId, String indexName, String translatedIndexName, String indexDescription, String indexType, String indexTypeName, String indexValues, Long indexOrder) {
        this.id = id;
        this.linkId = linkId;
        this.indexName = indexName;
        this.translatedIndexName = translatedIndexName;
        this.indexDescription = indexDescription;
        this.indexType = indexType;
        this.indexTypeName = indexTypeName;
        this.indexValues = indexValues;
        this.indexOrder = indexOrder;
    }

    public static class LinkIndexDtoBuilder {
        private Long id;
        private Long linkId;
        private String indexName;
        private String translatedIndexName;
        private String indexDescription;
        private String indexType;
        private String indexTypeName;
        private String indexValues;
        private Long indexOrder;

        LinkIndexDtoBuilder() {
        }

        public LinkIndexDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public LinkIndexDtoBuilder linkId(Long linkId) {
            this.linkId = linkId;
            return this;
        }

        public LinkIndexDtoBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public LinkIndexDtoBuilder translatedIndexName(String translatedIndexName) {
            this.translatedIndexName = translatedIndexName;
            return this;
        }

        public LinkIndexDtoBuilder indexDescription(String indexDescription) {
            this.indexDescription = indexDescription;
            return this;
        }

        public LinkIndexDtoBuilder indexType(String indexType) {
            this.indexType = indexType;
            return this;
        }

        public LinkIndexDtoBuilder indexTypeName(String indexTypeName) {
            this.indexTypeName = indexTypeName;
            return this;
        }

        public LinkIndexDtoBuilder indexValues(String indexValues) {
            this.indexValues = indexValues;
            return this;
        }

        public LinkIndexDtoBuilder indexOrder(Long indexOrder) {
            this.indexOrder = indexOrder;
            return this;
        }

        public LinkIndexDto build() {
            return new LinkIndexDto(this.id, this.linkId, this.indexName, this.translatedIndexName, this.indexDescription, this.indexType, this.indexTypeName, this.indexValues, this.indexOrder);
        }

        public String toString() {
            return "LinkIndexDto.LinkIndexDtoBuilder(id=" + this.id + ", linkId=" + this.linkId + ", indexName=" + this.indexName + ", translatedIndexName=" + this.translatedIndexName + ", indexDescription=" + this.indexDescription + ", indexType=" + this.indexType + ", indexTypeName=" + this.indexTypeName + ", indexValues=" + this.indexValues + ", indexOrder=" + this.indexOrder + ")";
        }
    }
}

