/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.simulation;

import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import com.suncode.pwfl.web.support.workflow.process.map.ProcessMapper;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.workflow.simulation.SimulationService;
import com.suncode.pwfl.workflow.simulation.delegated.SimulationProxy;
import com.suncode.pwfl.workflow.simulation.delegated.context.process.CreatedProcessDto;
import com.suncode.pwfl.workflow.simulation.delegated.exceptions.SimulationProxyException;
import com.suncode.pwfl.xpdl.builder.XpdlBuilderService;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"simulation"})
@Api(hidden=true)
public class SimulationController {
    private final SimulationService simulationService;
    private final ProcessMapper processMapper;
    private final Experimental experimental;

    @PostMapping
    public CreatedSimulationDto startSimulationWithProcess(@RequestBody ProcessDto processDto) {
        if (!this.experimental.hasFeature(ExperimentalFeature.SHARK_SIMULATION)) {
            throw new SimulationProxyException("Simulation is not allowed on this system");
        }
        Package pkg = new Package("simulation", "Simulation");
        Process process = this.processMapper.toProcess(processDto);
        pkg.getProcesses().add(process);
        String xpdlString = XpdlBuilderService.buildBy((Package)pkg);
        String userName = UserContext.current().getUser().getUserName();
        this.simulationService.findActiveByUserName(userName).ifPresent(SimulationProxy::close);
        SimulationProxy simulation = this.simulationService.createSimulation();
        try {
            simulation.getContext().getXpdlService().uploadXPDL("Simulation", xpdlString);
            CreatedProcessDto createdProcessDto = simulation.getContext().getProcessService().createProcess("simulation", process.getId());
            return new CreatedSimulationDto(simulation.getId(), createdProcessDto.getProcessId(), (String)createdProcessDto.getOpenedActivityIds().get(0));
        }
        catch (Exception e) {
            simulation.close();
            throw e;
        }
    }

    @DeleteMapping(value={"{id}"})
    public void stopSimulation(@PathVariable String id) {
        this.simulationService.findActiveById(id).ifPresent(SimulationProxy::close);
    }

    @ConstructorProperties(value={"simulationService", "processMapper", "experimental"})
    @Autowired
    public SimulationController(SimulationService simulationService, ProcessMapper processMapper, Experimental experimental) {
        this.simulationService = simulationService;
        this.processMapper = processMapper;
        this.experimental = experimental;
    }

    public record CreatedSimulationDto(String simulationId, String processId, String activityId) {
    }
}

