/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.form;

import com.plusmpm.util.classLoader.PlusClassLoader;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.script.ScriptHelper;
import com.suncode.pwfl.util.script.ScriptType;
import com.suncode.pwfl.web.dto.workflow.form.AutoUpdateDto;
import com.suncode.pwfl.web.dto.workflow.form.DataChooserParams;
import com.suncode.pwfl.web.jsonp.RequestWrapper;
import com.suncode.pwfl.web.jsonp.ResponseWrapper;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.AutoUpdate;
import com.suncode.pwfl.workflow.form.Form;
import com.suncode.pwfl.workflow.form.FormService;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserCaller;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RestController(value="apiFormController")
@RequestMapping(value={"/form"})
@Api(tags={"activity form"})
public class FormController {
    private static final Logger log = LoggerFactory.getLogger(FormController.class);
    private final String SCRIPTS_ROOT = "scripts/external/";
    @Autowired
    private FormService formService;
    @Autowired
    private ScriptHelper scriptHelper;
    @Autowired
    private ServletContext ctx;
    @Autowired
    private DataChooserCaller dataChooserCaller;

    @GetMapping
    @ResponseBody
    @ApiOperation(value="Downloading form definitions", notes="The answer contains a form definition object")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public Form getForm(@ApiParam(value="Id of the process", required=true) @RequestParam String processId, @ApiParam(value="Id of the activity", required=true) @RequestParam String activityId) {
        return this.formService.getForm(processId, activityId);
    }

    @GetMapping(value={"autoupdate"})
    @ResponseBody
    @ApiOperation(value="DEPRECATED AutoUpdate invocation", notes="The answer contains a map of processed variable values from the destination parameter of the autoUpdate definition\n- **autoUpdate** - AutoUpdate definition (taken from the form defnition) \n- **variables** - A map of variable values from the dataSource field in the autoUpdate definition. (The key in the map is the id of the variable)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public Map<String, Object> getAutoUpdate(@RequestBody AutoUpdateDto autoUpdate, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, SAXException, ParserConfigurationException {
        AutoUpdate autoUpdateDefinition = autoUpdate.getAutoUpdate();
        Map<String, Object> dataSources = autoUpdate.getVariables();
        RequestWrapper reqWrapper = new RequestWrapper(req);
        ResponseWrapper respWrapper = new ResponseWrapper(resp);
        this.convertParams(autoUpdateDefinition, dataSources, reqWrapper);
        String xml = this.executeAutoUpdate(autoUpdateDefinition.getTaskName(), reqWrapper, respWrapper);
        return this.parseAutoUpdateXml(xml, autoUpdateDefinition.getDestination());
    }

    private Map<String, Object> parseAutoUpdateXml(String xml, List<String> destinations) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(new InputSource(new StringReader(xml.trim())));
        doc.getDocumentElement().normalize();
        NodeList items = doc.getElementsByTagName("item");
        for (int i = 0; i < destinations.size(); ++i) {
            String varId = destinations.get(i);
            Node node = items.item(i);
            if (node == null) {
                log.info("Brak warto\u015bci dla zmiennej: {}", (Object)varId);
                map.put(varId, null);
                continue;
            }
            String value = node.getLastChild().getFirstChild().getNodeValue();
            map.put(varId, value);
        }
        return map;
    }

    private String executeAutoUpdate(String taskName, RequestWrapper reqWrapper, ResponseWrapper respWrapper) throws ServletException, IOException {
        RequestDispatcher rd = reqWrapper.getRequestDispatcher("/" + taskName);
        rd.forward((ServletRequest)reqWrapper, (ServletResponse)respWrapper);
        byte[] bytes = respWrapper.getData();
        String text = new String(bytes, "UTF-8");
        log.info("odpowied\u017a autoupdate: " + text);
        return text;
    }

    private void convertParams(AutoUpdate def, Map<String, Object> variables, RequestWrapper req) {
        int i = 0;
        for (String varId : def.getDataSource()) {
            if (i == 0) {
                req.addParameter("param", variables.get(varId).toString());
            } else {
                req.addParameter("param" + i, variables.get(varId).toString());
            }
            ++i;
        }
    }

    @PostMapping(value={"datachooser"})
    @ResponseBody
    @ApiOperation(value="DataChooser invocation", notes="Answer contains the list of data returned by datachooser\n- **className** - class of the datachooser \n- **start** - start of data \n- **limit** - number of records \n- **orderProperty** - sorting field \n- **order** - sorting direction (ASC/DESC) \n- **criteria** - map of variable values \n- **customKeys** - additional keys")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public CountedResult<Map<String, String>> getDataChooserData(@RequestBody DataChooserParams params) throws Exception {
        CountedResult result = new CountedResult();
        Map<String, String> customKeys = params.getCustomKeys();
        if (customKeys != null && customKeys.containsKey("componentId")) {
            String processId = customKeys.get("processId");
            String activityId = customKeys.get("activityId");
            String variableId = customKeys.get("variableId");
            Pagination pagination = Pagination.create((Sorter)new Sorter(params.getOrderProperty(), SortDirection.valueOf((String)params.getOrder())), (Integer)params.getStart(), (Integer)params.getLimit());
            String query = params.getCriteria().get("GetDataChooserContentServlet_parameter_query");
            if (StringUtils.isBlank((CharSequence)query)) {
                query = null;
            }
            ComponentQueryData queryData = new ComponentQueryData(pagination, query);
            DataChooserResult dcResult = this.dataChooserCaller.call(variableId, processId, activityId, queryData, params.getContext());
            result.setData(dcResult.getData());
            result.setTotal((long)dcResult.getTotal());
            return result;
        }
        PlusClassLoader classLoader = new PlusClassLoader();
        List data = (List)classLoader.executeClassMethod(params.getClassName(), "getDataChooserResult", new Object[]{params.getStart(), params.getLimit(), params.getOrderProperty(), params.getOrder(), params.getCriteria(), params.getCustomKeys()}, new Class[]{Integer.TYPE, Integer.TYPE, String.class, String.class, Map.class, Map.class});
        int size = (Integer)classLoader.executeClassMethod(params.getClassName(), "getDataChooserResultSize", new Object[]{params.getCriteria(), params.getCustomKeys()}, new Class[]{Map.class, Map.class});
        result.setData(data);
        result.setTotal((long)size);
        return result;
    }

    @GetMapping(value={"scripts"})
    @ResponseBody
    @ApiOperation(value="Downloading form scripts", notes="The answer contains the scripts used in the form")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad input parameter")})
    public List<String> getFormScripts(@ApiParam(value="Id of the process", required=true) @RequestParam String processId, @ApiParam(value="Id of the activity", required=true) @RequestParam String activityId, @ApiParam(value="Type of scripts (case sensitive)", required=true, allowableValues="DESKTOP,DESKTOP_FORM,DESKTOP_HISTORY,MOBILE,MOBILE_FORM,MOBILE_HISTORY") @RequestParam ScriptType type) {
        return this.scriptHelper.getScripts(processId, activityId, this.ctx.getRealPath("scripts/external/"), type);
    }
}

