/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.util.ClasspathScanner;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.pwfl.archive.DocumentClassAction;
import com.suncode.pwfl.archive.DocumentClassActionFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.ActionSourceDto;
import com.suncode.pwfl.web.dto.archive.CreateDocumentClassActionDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassActionDto;
import com.suncode.pwfl.web.dto.archive.UpdateDocumentClassActionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentClassActionMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"documents/classes/{documentClassId}/actions"})
@Api(tags={"document classes"})
public class DocumentClassActionController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassActionController.class);
    @Autowired
    private DocumentClassActionFinder documentClassActionFinder;
    @Autowired
    private DocumentClassActionMapper documentClassActionMapper;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ExportService exportService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ApiOperation(value="(Admin) Downloading document class actions sources", notes="Retrieves a list of available document class actions sources")
    @GetMapping(value={"sources"})
    @ResponseBody
    public List<ActionSourceDto> getDocumentClassActionSources(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return Arrays.stream(DocumentEventTypes.values()).map(this.documentClassActionMapper::toActionSourceDto).collect(Collectors.toList());
    }

    @ApiOperation(value="(Admin) Downloading document class actions scripts", notes="Retrieves a list of available document class actions scripts")
    @GetMapping(value={"scripts"})
    @ResponseBody
    public List<String> getScripts(@ApiParam(value="document class id", required=true) @PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return ClasspathScanner.getAllClassesWithInterface(DocumentEventHandler.class).stream().map(Class::getName).sorted(Comparator.comparing(String::toUpperCase)).collect(Collectors.toList());
    }

    @ApiOperation(value="(Admin) Downloading document class actions", notes="Retrieves a list of document class actions")
    @GetMapping
    @ResponseBody
    public CountedResult<DocumentClassActionDto> getDocumentClassActions(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Result number from which results are to be returned", required=true) @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results", required=true) @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", defaultValue="id") @RequestParam(required=false, defaultValue="id") String sortBy, @ApiParam(value="Sort direction", defaultValue="DESC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List docClassActions = this.documentClassActionFinder.findByDocumentClass(documentClassId, new String[]{"documentClass"}).stream().map(this.documentClassActionMapper::toDocumentClassActionDto).sorted((Comparator<DocumentClassActionDto>)DtoComparator.of(DocumentClassActionDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("source", dto -> dto.getSource().getName()).withSupport("type", dto -> dto.getType().getName()).withSupport("value", dto -> dto.getValue().getName())).collect(Collectors.toList());
        return Paginator.forAll(docClassActions).viewPageByOffset(start, limit);
    }

    @ApiOperation(value="(Admin) Downloading document class action", notes="Retrieves a document class action")
    @GetMapping(value={"{documentClassActionId}"})
    @ResponseBody
    public DocumentClassActionDto getDocumentClassAction(@ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Document class action id", required=true) @PathVariable Long documentClassActionId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.documentClassActionMapper.toDocumentClassActionDto((DocumentClassAction)this.documentClassActionFinder.get((Serializable)documentClassActionId, new String[]{"documentClass"}));
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PostMapping
    public RestResult addDocumentClassAction(HttpServletRequest request, @PathVariable Long documentClassId, @RequestBody CreateDocumentClassActionDto documentClassActionDto) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOC_CLASS_ACTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        auditParams.putAll(this.createAddActionAuditParams(documentClassActionDto));
        auditBuilder.params(auditParams);
        try {
            DocumentClassAction documentClassAction = this.documentClassActionMapper.toEntity(documentClassActionDto);
            this.documentClassService.addActionToDocumentClass(documentClassId, documentClassAction);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @PatchMapping(value={"{documentClassActionId}"})
    public RestResult updateDocumentClassAction(HttpServletRequest request, @PathVariable Long documentClassId, @PathVariable Long documentClassActionId, @RequestBody UpdateDocumentClassActionDto documentClassActionDto) {
        documentClassActionDto.setId(documentClassActionId);
        documentClassActionDto.setDocumentClassId(documentClassId);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_DOC_CLASS_ACTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        DocumentClassAction oldDocumentClassAction = (DocumentClassAction)this.documentClassActionFinder.get((Serializable)documentClassActionDto.getId());
        if (oldDocumentClassAction == null) {
            auditBuilder.buildFailure(request);
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_akcji_klasy_dokumentow", new Object[]{documentClassActionDto.getId()}));
        }
        auditParams.putAll(this.createUpdateActionAuditParams(documentClassActionDto, oldDocumentClassAction));
        auditBuilder.params(auditParams);
        try {
            DocumentClassAction documentClassAction = this.documentClassActionMapper.toEntity(documentClassActionDto);
            this.documentClassService.updateDocumentClassAction(documentClassAction);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Deleting document class action", notes="Deletes document class action with given id")
    @DeleteMapping(value={"{documentClassActionId}"})
    @ResponseBody
    public RestResult deleteDocumentClassAction(HttpServletRequest request, @ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Document class action id", required=true) @PathVariable Long documentClassActionId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOC_CLASS_ACTION).params(this.createDeleteActionAuditParams(documentClassId, documentClassActionId));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.documentClassService.deleteDocumentClassAction(documentClassActionId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Downloading document class actions", notes="Exports a list of document class actions")
    @GetMapping(value={"export/{extension}"})
    @ResponseBody
    public void exportDocumentClassActions(HttpServletResponse response, @ApiParam(value="Document class id", required=true) @PathVariable Long documentClassId, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Sort by", defaultValue="id") @RequestParam(required=false, defaultValue="id") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List documentClassActions = this.documentClassActionFinder.findByDocumentClass(documentClassId, new String[]{"documentClass"}).stream().map(this.documentClassActionMapper::toDocumentClassActionDto).sorted((Comparator<DocumentClassActionDto>)DtoComparator.of(DocumentClassActionDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("source", dto -> dto.getSource().getName()).withSupport("type", dto -> dto.getType().getName()).withSupport("value", dto -> dto.getValue().getName())).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_akcji")).data(documentClassActions).by(DocumentClassActionDto::getName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zrodlo_akcji")).data(documentClassActions).by(documentClassActionDto -> documentClassActionDto.getSource().getName()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_akcji")).data(documentClassActions).by(documentClassActionDto -> documentClassActionDto.getType().getName()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wartosc")).data(documentClassActions).by(documentClassActionDto -> documentClassActionDto.getValue().getName()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Mapowanie")).data(documentClassActions).by(documentClassActionDto -> this.documentClassActionMapper.getFormattedMappings(documentClassActionDto.getMappings())).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wykonuj_dla_nowych_wersji")).data(documentClassActions).by(documentClassActionDto -> documentClassActionDto.getInvokeForNewVersion() != false ? this.messageHelper.getMessage("Tak") : this.messageHelper.getMessage("Nie")).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Akcje")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private Map<String, Object> createAddActionAuditParams(CreateDocumentClassActionDto documentClassActionDto) {
        String actionProcess = documentClassActionDto.getValue().getValue() != null ? documentClassActionDto.getValue().getValue() : "";
        return ImmutableMap.builder().put((Object)"actionName", (Object)documentClassActionDto.getName()).put((Object)"actionSource", (Object)documentClassActionDto.getSource().getValue().value).put((Object)"actionType", (Object)documentClassActionDto.getType().getValue().value).put((Object)"actionProcess", (Object)actionProcess).build();
    }

    private Map<String, Object> createUpdateActionAuditParams(UpdateDocumentClassActionDto documentClassActionDto, DocumentClassAction oldDocumentClassAction) {
        return ImmutableMap.builder().put((Object)"actionName", (Object)String.format("%s > %s", oldDocumentClassAction.getName(), documentClassActionDto.getName())).put((Object)"actionSource", (Object)documentClassActionDto.getSource().getValue().value).put((Object)"actionType", (Object)documentClassActionDto.getType().getValue().value).put((Object)"actionProcess", (Object)documentClassActionDto.getValue().getValue()).build();
    }

    private Map<String, Object> createDeleteActionAuditParams(Long documentClassId, Long documentClassActionId) {
        return ImmutableMap.builder().put((Object)"docclassId", (Object)documentClassId).put((Object)"actionId", (Object)documentClassActionId).build();
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class, Exception.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequests(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

