/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.security;

import com.suncode.pwfl.web.CsrfTokenDto;
import com.suncode.pwfl.web.CsrfTokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"csrf"})
@Api(tags={"CSRF Security"})
public class CsrfController {
    @Autowired
    private CsrfTokenService csrfTokenService;

    @ApiOperation(value="Get CSRF Token", notes="Retrieves a CSRF token for the current session. This token should be included in subsequent requests that require CSRF protection.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved CSRF token"), @ApiResponse(code=500, message="CSRF token not present in session")})
    @GetMapping(value={"token"})
    @ResponseBody
    public CsrfTokenDto getCsrf(HttpServletRequest request) {
        return (CsrfTokenDto)this.csrfTokenService.getMaskedCsrfToken(request).orElseThrow(() -> new IllegalStateException("Csrf token is not present is session"));
    }
}

