/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.report;

import com.plusmpm.util.reports.ReportPermissions;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.extension.ExportExtensionValueNotFound;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.report.exception.ReportNotFoundException;
import com.suncode.pwfl.report.export.ReportExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"report"})
@Api(tags={"report"})
public class ReportController {
    private static final Logger log = LoggerFactory.getLogger(ReportController.class);
    private final ReportExportService reportExportService;
    private final MessageHelperBean messageHelper;

    @GetMapping(value={"{reportId}/export/{extension}"})
    @ApiOperation(value="Export report", notes="Exports the specified report in the requested file format")
    public ResponseEntity<?> exportReport(HttpServletResponse response, @ApiParam(value="ID of the report to export", required=true) @PathVariable Long reportId, @ApiParam(value="File extension to export the report as (pdf, xlsx, csv)", required=true) @PathVariable String extension) throws IOException {
        String userName = UserContext.current().getUser().getUserName();
        if (!ReportPermissions.reportPermissions((String)userName, (String)String.valueOf(reportId))) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            ExportExtension exportExtension = ExportExtension.getExportExtension((String)extension);
            String fileName = "raport." + exportExtension.getExtension();
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName));
            this.reportExportService.exportReport(reportId, exportExtension, (OutputStream)response.getOutputStream());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (ReportNotFoundException e) {
            log.info(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (ExportExtensionValueNotFound e) {
            log.info(e.getMessage(), (Throwable)e);
            String supportedExtensions = Arrays.stream(ExportExtension.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", "));
            return new ResponseEntity((Object)this.messageHelper.getMessage("Podany_typ_pliku_nie_jest_wspierany", new Object[]{supportedExtensions}), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @ConstructorProperties(value={"reportExportService", "messageHelper"})
    @Autowired
    public ReportController(ReportExportService reportExportService, MessageHelperBean messageHelper) {
        this.reportExportService = reportExportService;
        this.messageHelper = messageHelper;
    }
}

