/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.llm;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.PlusWorkflowTempFileCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.TempFileStream;
import com.suncode.pwfl.cache.config.DefaultCacheConfig;
import com.suncode.pwfl.cache.config.TempFileCacheConfig;
import com.suncode.pwfl.cache.exception.PlusWorkflowCacheException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.support.ParametrizedRuntimeException;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.io.DownloadResource;
import com.suncode.pwfl.web.support.workflow.process.map.ProcessMapper;
import com.suncode.pwfl.web.support.workflow.process.summary.ProcessMapSummaryGenerator;
import com.suncode.pwfl.workflow.editor.map.UnknownIntentionException;
import com.suncode.pwfl.workflow.process.map.LlmProcessMapBuilder;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.xpdl.builder.XpdlBuilderService;
import io.swagger.annotations.Api;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/llm"})
@Api(hidden=true)
public class LlmController {
    private static final Logger log = LoggerFactory.getLogger(LlmController.class);
    private final LlmProcessMapBuilder mapBuilder;
    private final ProcessMapper processMapper;
    private final MessageHelperBean messageHelperBean;
    private final CacheFactory cacheFactory;
    private final ProcessMapSummaryGenerator processMapSummaryGenerator;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private PlusWorkflowTempFileCache xpdlCache;
    private PlusWorkflowCache<String, ProcessDto> processDtoCache;

    @PostConstruct
    private void initialize() {
        this.xpdlCache = this.cacheFactory.createTempFileCache(SystemCacheId.XPDL_CACHE, TempFileCacheConfig.builder().build());
        this.processDtoCache = this.cacheFactory.createCache(SystemCacheId.PROCESS_MAP_CACHE, DefaultCacheConfig.builder().expireAfterWrite(Duration.ofHours(8L)).build());
    }

    @PostMapping(value={"{chatId}/process"})
    public LlmResponse buildProcessMapFromPrompt(@PathVariable String chatId, @RequestBody String prompt) throws JsonProcessingException, ExecutionException {
        try {
            ProcessDto currentProcessDto = (ProcessDto)this.processDtoCache.get((Object)chatId);
            if (currentProcessDto == null) {
                return new LlmResponse(null, this.messageHelperBean.getMessage("Problem_podczas_generowania_mapy_procesu"), true);
            }
            Process process = this.mapBuilder.buildProcessMapFromPrompt(prompt);
            ProcessDto processDto = this.processMapper.toDto(process);
            processDto.setVersion(currentProcessDto.getVersion() + 1);
            this.processDtoCache.put((Object)chatId, (Object)processDto);
            return new LlmResponse(processDto, this.processMapSummaryGenerator.generateSummary(processDto), false);
        }
        catch (UnknownIntentionException e) {
            return new LlmResponse(null, this.messageHelperBean.getMessage("Problem_podczas_generowania_mapy_procesu"), true);
        }
    }

    @PostMapping(value={"/process/xpdl"})
    public UUID buildProcessMapFromPrompt(@RequestBody ProcessDto processDto) {
        Process process = this.processMapper.toProcess(processDto);
        String packageId = UUID.randomUUID().toString().substring(0, 10);
        String packageName = "Process Map %s".formatted(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        Package pkg = new Package(packageId, packageName);
        pkg.getProcesses().add(process);
        String xpdlContent = XpdlBuilderService.buildBy((Package)pkg);
        return this.xpdlCache.put(packageId + ".xpdl", xpdlContent);
    }

    @PostMapping(value={"{chatId}/process/sync"})
    public ResponseEntity<?> sync(@PathVariable String chatId, @RequestBody ProcessDto processDto) throws ExecutionException {
        if (this.processDtoCache.get((Object)chatId) != null) {
            return new ResponseEntity((Object)"Process is already on the server", (HttpStatusCode)HttpStatus.CONFLICT);
        }
        processDto.setVersion(1);
        this.processDtoCache.put((Object)chatId, (Object)processDto);
        return new ResponseEntity((Object)processDto.getVersion(), (HttpStatusCode)HttpStatus.OK);
    }

    @PatchMapping(value={"{chatId}/process/sync"})
    public ResponseEntity<?> sync(@PathVariable String chatId, @RequestBody JsonPatch patch) throws ExecutionException {
        ProcessDto processDto = (ProcessDto)this.processDtoCache.get((Object)chatId);
        if (processDto == null) {
            return new ResponseEntity((Object)"Process not found", (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        try {
            int currentVersion = processDto.getVersion();
            JsonNode processNode = this.objectMapper.valueToTree((Object)processDto);
            JsonNode patchedNode = patch.apply(processNode);
            ProcessDto patchedProcessDto = (ProcessDto)this.objectMapper.treeToValue((TreeNode)patchedNode, ProcessDto.class);
            int newVersion = currentVersion + 1;
            patchedProcessDto.setVersion(newVersion);
            this.processDtoCache.put((Object)chatId, (Object)patchedProcessDto);
            return new ResponseEntity((Object)newVersion, (HttpStatusCode)HttpStatus.OK);
        }
        catch (JsonPatchException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
        catch (Exception e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"{chatId}/process/sync"})
    public ResponseEntity<?> sync(@PathVariable String chatId) throws JsonProcessingException, ExecutionException {
        ProcessDto processDto = (ProcessDto)this.processDtoCache.get((Object)chatId);
        if (processDto == null) {
            return new ResponseEntity((Object)"Process not found", (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)processDto, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/process/xpdl"})
    public DownloadResource getProcessMapAsXpdl(@RequestParam UUID uuid) {
        TempFileStream xpdlStream = (TempFileStream)this.xpdlCache.getValueStream(uuid, true).orElseThrow(() -> new PlusWorkflowCacheException(String.valueOf(uuid) + " not found in cache"));
        return new DownloadResource(xpdlStream);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult handleBadRequest(ParametrizedRuntimeException e) {
        return new RestResult(false, this.messageHelperBean.getMessage(e.getMessageKey()));
    }

    @ExceptionHandler(value={PlusWorkflowCacheException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public RestResult handleBadRequest(PlusWorkflowCacheException e) {
        log.warn("Value not found in cache", (Throwable)e);
        return new RestResult(false);
    }

    @ConstructorProperties(value={"mapBuilder", "processMapper", "messageHelperBean", "cacheFactory", "processMapSummaryGenerator"})
    @Autowired
    public LlmController(LlmProcessMapBuilder mapBuilder, ProcessMapper processMapper, MessageHelperBean messageHelperBean, CacheFactory cacheFactory, ProcessMapSummaryGenerator processMapSummaryGenerator) {
        this.mapBuilder = mapBuilder;
        this.processMapper = processMapper;
        this.messageHelperBean = messageHelperBean;
        this.cacheFactory = cacheFactory;
        this.processMapSummaryGenerator = processMapSummaryGenerator;
    }

    record LlmResponse(ProcessDto process, String summary, boolean isError) {
    }
}

