/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.health;

import com.plusmpm.util.Authorization;
import com.suncode.pwfl.health.HealthStatusEnum;
import com.suncode.pwfl.health.dto.HealthStatus;
import com.suncode.pwfl.health.service.HealthCheckServiceImpl;
import com.suncode.pwfl.web.util.SessionUtils;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"health"}, produces={"application/json"})
public class HealthController {
    private static final Logger log = LoggerFactory.getLogger(HealthController.class);
    private final HealthCheckServiceImpl healthCheckService;

    @GetMapping
    @ResponseBody
    public ResponseEntity<HealthStatus> health() {
        return this.performHealthCheckAndReturnResponse(true);
    }

    @GetMapping(value={"details"})
    @ResponseBody
    public ResponseEntity<HealthStatus> healthDetails() {
        String userName = SessionUtils.getLoggedUserName();
        if (StringUtils.isBlank((CharSequence)userName) || !Authorization.checkIsUserAdmin((String)userName)) {
            HealthStatus healthStatus = HealthStatus.builder().error("No permissions").build();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)healthStatus);
        }
        return this.performHealthCheckAndReturnResponse(false);
    }

    private ResponseEntity<HealthStatus> performHealthCheckAndReturnResponse(boolean basic) {
        HealthStatus healthStatus = this.healthCheckService.performHealthCheck(basic);
        HealthStatusEnum status = healthStatus.getStatus();
        HttpStatus httpStatus = this.determineHttpStatus(status);
        return ResponseEntity.status((HttpStatusCode)httpStatus).body((Object)healthStatus);
    }

    private HttpStatus determineHttpStatus(HealthStatusEnum status) {
        if (status == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case HealthStatusEnum.UP, HealthStatusEnum.WARNING -> HttpStatus.OK;
            case HealthStatusEnum.DOWN -> HttpStatus.SERVICE_UNAVAILABLE;
        };
    }

    @ConstructorProperties(value={"healthCheckService"})
    @Autowired
    public HealthController(HealthCheckServiceImpl healthCheckService) {
        this.healthCheckService = healthCheckService;
    }
}

