/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.ldap.LdapErrorCodes;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.security.LdapPasswordChanger;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"password/ldap"})
public class LdapUserPasswordController {
    private static Logger log = Logger.getLogger(LdapUserPasswordController.class);
    @Autowired
    UserService userService;
    @Autowired
    DomainService domainService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"change"}, method={RequestMethod.POST})
    public ResponseEntity<Map<String, Object>> changePassword(HttpServletRequest request, @RequestParam(value="domain") String domainName, @RequestParam(value="username") String username, @RequestParam(value="currentPassword") String currentPassword, @RequestParam(value="password") String newPassword) {
        try (LdapPasswordChanger ldapPasswordChanger = null;){
            Domain domain = this.domainService.getByName(domainName, new String[0]);
            ldapPasswordChanger = new LdapPasswordChanger(domain, username, currentPassword);
            ldapPasswordChanger.changeUserPassword(newPassword);
            request.setAttribute("audit", (Object)this.buildAudit(username, true));
            ResponseEntity responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
    }

    private AuditWrapper buildAudit(String username, boolean success) {
        return AuditBuilder.getInstance().type(AuditTypes.AUDIT_LDAP_CHANGE_PASSWORD).params((Map)ImmutableMap.of((Object)"username", (Object)username)).success(success).build();
    }

    private ImmutableMap<String, Object> getError(String errorMessage) {
        LdapErrorCodes errorCode = LdapErrorCodes.extractCodeFromErrorMessage((String)errorMessage);
        if (errorCode == LdapErrorCodes.LDAP_52e) {
            return ImmutableMap.of((Object)"incorrectCurrentPassword", (Object)true);
        }
        if (errorCode == LdapErrorCodes.LDAP_53) {
            return ImmutableMap.of((Object)"serverRestrictions", (Object)MessageHelper.getMessage((String)LdapErrorCodes.LDAP_53.getErrorMessage()));
        }
        return ImmutableMap.of((Object)"", (Object)true);
    }
}

