/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.workflow.activities.ActivityStatus;
import com.plusmpm.database.workflow.activities.ActivityStatusManagerExtended;
import com.plusmpm.struts.action.ProcessActivityContext;
import com.plusmpm.struts.action.ProcessActivityResult;
import com.plusmpm.struts.action.SearchTaskAction;
import com.plusmpm.struts.action.ShowDetailHistoryAction;
import com.plusmpm.struts.action.ShowWorkListAction;
import com.plusmpm.struts.action.util.MessageType;
import com.plusmpm.struts.form.TaskBeanForm;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.form.service.SystemContextService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.shark.SharkContext;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.activity.DelegatedActivityDtoConverter;
import com.suncode.pwfl.web.dto.administration.SystemParameterDto;
import com.suncode.pwfl.web.support.UserAgentUtils;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.form.FormBuilderService;
import com.suncode.pwfl.workflow.form.action.ActionUIFragment;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.internal.InternalProcessService;
import com.suncode.pwfl.workflow.process.internal.exception.ActivitySuspended;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAccepted;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAcceptedOrAcceptingByAnotherUser;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAcceptingByAnotherUser;
import com.suncode.pwfl.workflow.process.internal.exception.ProcessLockTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;

public class ProcesActivityAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(ProcesActivityAction.class);
    public String initActivityId;
    public String initProcessId;
    public String initMessage;
    private static ObjectMapper mapper = new ObjectMapper();
    private static final ConcurrentHashMap<String, String> lockedActivities = new ConcurrentHashMap();
    private static ShaKey processKeyGenerator = (ShaKey)SpringContext.getBean(ShaKey.class);
    private static FormBuilderService formBuilderService = (FormBuilderService)SpringContext.getBean(FormBuilderService.class);
    private static SystemParameterFinder systemParameterFinder = (SystemParameterFinder)SpringContext.getBean(SystemParameterFinder.class);
    private static TransactionWrapper transactionWrapper = (TransactionWrapper)SpringContext.getBean(TransactionWrapper.class);
    private static SharkTransactionManager sharkTransactionManager = (SharkTransactionManager)SpringContext.getBean(SharkTransactionManager.class);
    private static DelegatedActivityDtoConverter delegatedActivityDtoConverter = (DelegatedActivityDtoConverter)SpringContext.getBean(DelegatedActivityDtoConverter.class);
    private static InternalProcessService internalProcessService = (InternalProcessService)SpringContext.getBean(InternalProcessService.class);
    private static SystemContextService systemContextService = (SystemContextService)SpringContext.getBean(SystemContextService.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ActionForward)SharkContext.LOCAL.withNewContext((Object)SharkContext.ofShorterTimeouts()).execute(context -> {
            try {
                return this.executeAction(mapping, form, request, response);
            }
            catch (Exception e) {
                log.error("An unexpected error occurred while trying to enter activity", (Throwable)e);
                Locale locale = LocaleContextHolder.getLocale();
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Wystapil_nieoczekiwany_blad_przy_probie_wejscia_w_zadanie", (Locale)locale, (Object[])new Object[0]));
                return this.forwardToNoTask(mapping);
            }
        });
    }

    private ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProcessActivityResult result;
        HttpSession session = request.getSession(false);
        ProcessActivityContext context = this.buildContext(request, session);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("processKey", context.getProcessId());
        auditParams.put("activityId", context.getActivityId());
        auditParams.putAll(UserAgentUtils.resolveUserAgentAuditParams(request));
        AuditBuilder audit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OPEN_ACTIVITY).params(auditParams);
        this.resolveSessionUsername(request, session, context.getUsername());
        this.resolveExternalClick(session);
        Optional<ActionForward> preForward = this.getPreForward(request, mapping, response, context.getActivityId(), context.getProcessId(), form);
        if (preForward.isPresent()) {
            return preForward.get();
        }
        try {
            result = (ProcessActivityResult)transactionWrapper.doInSharkTransaction(transaction -> {
                Locale locale = context.getLocale();
                String username = context.getUsername();
                try {
                    ProcessActivityResult processActivityResult = this.proceed(context, transaction);
                    return processActivityResult;
                }
                catch (AlreadyAccepted ex) {
                    log.info("Zadanie jest ju\u017c wykonane");
                    this.setMessage(request, locale, username, "nie_moze_wykonac_tego_zadania_gdyz_zostalo_ono_juz_wykonane_lub_jest_aktualnie_wykonywane_przez_innego_uzytkownika");
                }
                catch (ActivitySuspended ex) {
                    log.info("Zadanie jest zawieszone");
                    this.setMessage(request, locale, context.getUsername(), "nie_moze_wykonac_tego_zadania_gdyz_zadanie_jest_zawieszone");
                }
                catch (AlreadyAcceptedOrAcceptingByAnotherUser ex) {
                    log.info("Zadanie zosta\u0142o wykonane lub jest wykonywane przez innego u\u017cytkownika");
                    this.setMessage(request, locale, username, "nie_moze_wykonac_tego_zadania_gdyz_zostalo_ono_juz_wykonane_lub_jest_aktualnie_wykonywane_przez_innego_uzytkownika");
                }
                catch (AlreadyAcceptingByAnotherUser ex) {
                    log.info("Zadanie jest wykonywane przez innego u\u017cytkownika");
                    this.setMessage(request, locale, username, "nie_moze_wykonac_tego_zadania_gdyz_wykonywane_jest_ono_przez_innego_uzytkownika");
                }
                catch (ProcessLockTimeoutException e) {
                    log.error("Zadanie jest obecnie wykorzystywane przez inn\u0105 operacj\u0119 w systemie", (Throwable)e);
                    request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Zadanie_jest_obecnie_wykorzystywane_przez_inna_operacje_w_systemie_Sprobuj_ponownie_pozniej", (Locale)locale, (Object[])new Object[0]));
                    request.setAttribute("messageType", (Object)MessageType.WARNING);
                }
                catch (Exception exception) {
                    if (transaction != null) {
                        Shark.getInstance().emptyCaches(transaction);
                    }
                    throw exception;
                }
                finally {
                    if (username.equals(lockedActivities.get(context.getActivityId()))) {
                        lockedActivities.remove(context.getActivityId());
                    }
                }
                return ProcessActivityResult.builder().forwardResult(this.forwardToNoTask(mapping)).build();
            });
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("auditSuccess", (Object)false);
            request.setAttribute("audit", (Object)audit.buildFailure());
            throw ex;
        }
        if (result.getForwardResult() != null) {
            return result.getForwardResult();
        }
        request.setAttribute("realusername", (Object)result.getRealUsername());
        request.setAttribute("taskusername", (Object)context.getUsername());
        request.setAttribute("originaltaskusername", session.getAttribute("originalusername"));
        request.setAttribute("message", (Object)result.getMessage());
        request.setAttribute("processId", (Object)result.getProcessId());
        request.setAttribute("activityId", (Object)result.getActivityId());
        String processRightKey = processKeyGenerator.get(result.getProcessId());
        request.setAttribute("processRightKey", (Object)processRightKey);
        request.setAttribute("processDefId", (Object)result.getProcessDefId());
        request.setAttribute("activityDefId", (Object)result.getActivityDefId());
        request.setAttribute("processName", (Object)result.getProcessName());
        request.setAttribute("activityName", (Object)PackageTranslationHelper.getActivityName((String)result.getPackageId(), (String)result.getProcessDefId(), (String)result.getActivityDefId()));
        request.setAttribute("packageId", (Object)result.getPackageId());
        request.setAttribute("packageVersion", (Object)result.getPackageVersion());
        request.setAttribute("suncodeForm", (Object)formBuilderService.build(result.getProcessId(), result.getActivityId(), context.getUsername(), session.getId(), ActionUIFragment.FORM, processRightKey, context.getViewId(), context.getSource()));
        request.setAttribute("devMode", (Object)Boolean.valueOf(request.getParameter("devMode")));
        request.setAttribute("redirect", (Object)StringUtils.defaultString((String)request.getParameter("redirect")));
        request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
        request.setAttribute("systemParameters", (Object)this.getSystemParametersJson());
        request.setAttribute("systemContext", (Object)systemContextService.buildSystemContextJson());
        request.setAttribute("activityDelegations", (Object)this.getActivityDelegationsJson(context.getActivityId(), context.getUsername()));
        request.setAttribute("auditSuccess", (Object)true);
        request.setAttribute("audit", (Object)audit.buildSuccess());
        if (Boolean.valueOf(request.getParameter("cal")).booleanValue()) {
            return this.forwardToTaskBody(mapping);
        }
        return this.forwardToTask(mapping);
    }

    private ProcessActivityResult proceed(ProcessActivityContext context, SharkTransaction transaction) {
        log.debug(String.format("Start checking if activity [%s] can be open", context.getActivityId()));
        WfAssignment currentAssignment = internalProcessService.checkIfCanOpen(transaction, context.getUsername(), context.getProcessId(), context.getActivityId());
        log.debug(String.format("Finish checking if activity [%s] can be open", context.getActivityId()));
        HttpSession session = context.getSession();
        String processId = context.getProcessId();
        String activityId = context.getActivityId();
        String username = context.getUsername();
        session.setAttribute("activityId", (Object)activityId);
        session.setAttribute("processKey", (Object)processId);
        WfActivity currentActivity = currentAssignment.activity(transaction);
        Assert.isTrue((boolean)FinderFactory.getProcessFinder().findProcessIdByActivityId(activityId).equals(processId), (String)("Activity " + activityId + " does not belong to process " + processId));
        if (!currentAssignment.get_accepted_status(transaction)) {
            try {
                String activityState = currentActivity.state(transaction);
                if (activityState.compareToIgnoreCase("open.running") != 0) {
                    log.debug(String.format("Start changing state of activity [%s] to open.running", activityId));
                    currentActivity.change_state(transaction, "open.running");
                    log.debug(String.format("Finish changing state of activity [%s] to open.running", activityId));
                }
                DBManagement.SaveAcceptedTime((String)activityId, (boolean)true);
                if (lockedActivities.putIfAbsent(activityId, username) != null) {
                    throw new AlreadyAcceptedOrAcceptingByAnotherUser();
                }
            }
            catch (Exception ex) {
                if (ex instanceof AlreadyAcceptedOrAcceptingByAnotherUser) {
                    throw ex;
                }
                String activityState = currentActivity.state(transaction);
                if (activityState.equals("open.running")) {
                    log.warn("Wyst\u0105pi\u0142 b\u0142\u0105d przy zmianie statusu:" + ex.getMessage() + "-" + ex.getLocalizedMessage());
                }
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (currentAssignment.get_accepted_status(transaction)) {
            ExecutionAdministration executionAdministration = SharkUtils.createExecutionAdministration((String)username);
            WfResource userResource = executionAdministration.getResource(transaction, username);
            currentAssignment = SharkFunctions.GetWfAssignment((SharkTransaction)transaction, (ExecutionAdministration)executionAdministration, (String)processId, (String)activityId, (String)username);
            if (currentAssignment == null) {
                throw new AlreadyAccepted();
            }
            if (!userResource.is_member_of_work_items(transaction, currentAssignment)) {
                throw new AlreadyAcceptingByAnotherUser();
            }
        }
        AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
        String processDefId = adminMisc.getProcessDefinitionId(transaction, processId);
        String activityDefId = adminMisc.getActivityDefinitionId(transaction, processId, activityId);
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessId(transaction, processId);
        String message = context.getMessage();
        ActivityStatus activityStatus = ActivityStatusManagerExtended.getActivityCurrentStatus((String)processId, (String)activityId);
        if (activityStatus != null) {
            message = MessageHelper.getOptionalMessage((String)"ponowna_akceptacja_warn_msg");
        }
        String realUsername = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(sharkTransactionManager.getUserTransaction(), username);
        Process process = ServiceFactory.getProcessService().getProcess(processId, new String[0]);
        return ProcessActivityResult.builder().processId(processId).activityId(activityId).processDefId(processDefId).activityDefId(activityDefId).packageId(pack.getId()).packageVersion(pack.getInternalVersion()).realUsername(realUsername).message(message).processName(process.getName()).build();
    }

    private ProcessActivityContext buildContext(HttpServletRequest request, HttpSession session) {
        Locale locale = LocaleContextHolder.getLocale();
        String username = (String)session.getAttribute("username");
        String message = this.resolveMessage(request, locale);
        String activityId = this.resolveActivityId(request, session);
        String processId = this.resolveProcessId(request, session);
        Long viewId = this.resolveViewId(request);
        String source = this.resolveSource(request);
        return ProcessActivityContext.builder().processId(processId).activityId(activityId).username(username).locale(locale).message(message).request(request).session(session).viewId(viewId).source(source).build();
    }

    private void resolveExternalClick(HttpSession session) {
        String externalClick = (String)session.getAttribute("externalClick");
        if (externalClick != null && externalClick.compareToIgnoreCase("ProcesActivity") == 0) {
            session.setAttribute("externalClick", null);
            session.setAttribute("activityId", null);
            session.setAttribute("processKey", null);
        }
    }

    private Optional<ActionForward> getPreForward(HttpServletRequest request, ActionMapping mapping, HttpServletResponse response, String activityId, String processId, ActionForm form) throws Exception {
        String processTaskType = request.getParameter("procTaskType");
        String processName = request.getParameter("procName");
        if (processTaskType != null && (processTaskType.compareToIgnoreCase("closeTask") == 0 || processTaskType.compareToIgnoreCase("futureTask") == 0)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)processName, (CharSequence)"procname")) {
                return Optional.of(this.goToSearch(mapping, request, response));
            }
            return Optional.of(this.goToHistory(mapping, form, request, response, activityId, processId));
        }
        if (processName != null && processName.compareToIgnoreCase("procname") == 0) {
            return Optional.of(this.goToWorkList(mapping, form, request, response));
        }
        return Optional.empty();
    }

    private ActionForward forwardToTask(ActionMapping mapping) {
        return mapping.findForward("task");
    }

    private ActionForward forwardToTaskBody(ActionMapping mapping) {
        return mapping.findForward("taskbody");
    }

    private void setMessage(HttpServletRequest request, Locale locale, String username, String message) {
        String formattedMessage = String.format("%s: %s %s.", MessageHelper.getOptionalMessage((String)"Uzytkownik", (Locale)locale, (Object[])new Object[0]), username, MessageHelper.getOptionalMessage((String)message, (Locale)locale, (Object[])new Object[0]));
        request.setAttribute("message", (Object)formattedMessage);
    }

    private ActionForward forwardToNoTask(ActionMapping mapping) {
        return mapping.findForward("notask");
    }

    private ActionForward goToWorkList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("Forward to showWorkListAction");
        ShowWorkListAction showWorkListAction = new ShowWorkListAction();
        return showWorkListAction.execute(mapping, form, request, response);
    }

    private ActionForward goToSearch(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("Forward to SearchTaskAction");
        TaskBeanForm taskSearchBeanForm = new TaskBeanForm();
        SearchTaskAction searchTaskAction = new SearchTaskAction();
        return searchTaskAction.execute(mapping, (ActionForm)taskSearchBeanForm, request, response);
    }

    private ActionForward goToHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String activityId, String processId) throws Exception {
        log.debug("Forward to ShowDetailHistoryAction");
        ShowDetailHistoryAction showDetailHistoryAction = new ShowDetailHistoryAction();
        showDetailHistoryAction.m_histActivityId = activityId;
        showDetailHistoryAction.m_processKey = processId;
        return showDetailHistoryAction.execute(mapping, form, request, response);
    }

    private String resolveMessage(HttpServletRequest request, Locale locale) {
        String message = request.getParameter("message");
        if (StringUtils.isNotBlank((CharSequence)this.initMessage)) {
            this.initMessage = MessageHelper.getOptionalMessage((String)this.initMessage, (Locale)locale, (Object[])new Object[0]);
        }
        return message;
    }

    private String resolveProcessId(HttpServletRequest request, HttpSession session) {
        String processKey = request.getParameter("processKey");
        if (processKey == null) {
            processKey = StringUtils.isNotEmpty((CharSequence)this.initProcessId) ? this.initProcessId : (String)session.getAttribute("processKey");
        }
        return processKey;
    }

    private Long resolveViewId(HttpServletRequest request) {
        String stringViewId = request.getParameter("viewId");
        if (StringUtils.isNotEmpty((CharSequence)stringViewId)) {
            return Long.parseLong(stringViewId);
        }
        return null;
    }

    private String resolveSource(HttpServletRequest request) {
        String acceptanceSource = request.getParameter("acceptanceSource");
        return StringUtils.isNotBlank((CharSequence)acceptanceSource) ? acceptanceSource : null;
    }

    private String resolveActivityId(HttpServletRequest request, HttpSession session) {
        String activityId = request.getParameter("activityId");
        boolean lastActivityToRun = "true".equals(request.getParameter("lastOpenActivity"));
        if (activityId == null && lastActivityToRun) {
            Activity lastOpenActivity = FinderFactory.getActivityFinder().findLastOpenActivity(this.resolveProcessId(request, session));
            return lastOpenActivity != null ? lastOpenActivity.getActivityId() : null;
        }
        if (activityId == null) {
            activityId = StringUtils.isNotEmpty((CharSequence)this.initActivityId) ? this.initActivityId : (String)session.getAttribute("activityId");
        }
        return activityId;
    }

    private void resolveSessionUsername(HttpServletRequest request, HttpSession session, String username) {
        if (username == null) {
            session.setAttribute("username", (Object)request.getParameter("username"));
            session.setAttribute("domain", (Object)request.getParameter("domain"));
        }
    }

    private String getSystemParametersJson() {
        List parameters = systemParameterFinder.getPublicSystemParameters(new String[0]);
        List parametersDto = parameters.stream().map(SystemParameterDto::create).sorted().collect(Collectors.toList());
        return StringEscapeUtils.escapeJavaScript((String)mapper.writeValueAsString(parametersDto));
    }

    private String getActivityDelegationsJson(String activityId, String userName) {
        List delegatedActs = ServiceFactory.getActivityService().getActivityDelegations(activityId, userName);
        if (CollectionUtils.isNotEmpty((Collection)delegatedActs)) {
            List delegatedActsDto = delegatedActs.stream().map(delegatedActivityDtoConverter::convertToDto).sorted().collect(Collectors.toList());
            return StringEscapeUtils.escapeJavaScript((String)mapper.writeValueAsString(delegatedActsDto));
        }
        return "{}";
    }
}

