(function (Ext) {
  Ext.define('Suncode.datasourcemanager.component.DataSourceResultGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.datasourceresultgrid',

    uuid: undefined,

    constructor: function (columns, uuid) {
      this.uuid = uuid;
      var gridColumns = [];
      this.storeFields = [];
      Ext.each(
        columns,
        function (column, index) {
          gridColumns.push({
            text: column.name,
            dataIndex: column.id,
          });
          this.storeFields.push(column.id);
        },
        this
      );
      this.columns = gridColumns;
      this.callParent(arguments);
    },

    initComponent: function () {
      var me = this;
      var store = Ext.create('Ext.data.Store', {
        fields: me.storeFields,
        autoLoad: true,
        pageSize: 20,
        remoteSort: true,
        sorters: [
          {
            property: me.storeFields[0],
            direction: 'ASC',
          },
        ],
        proxy: {
          reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
            messageProperty: 'message',
          },
          type: 'ajax',
          url: Suncode.getAbsolutePath('api/datasources/temporary/' + me.uuid + '/data'),
          listeners: {
            exception: function (proxy, response, operation) {
              me.up('window').close();
              PW.ui.Message.warning(operation.error, { hideAfter: 0, showCopyButton: true });
            },
          },
          timeout: 600000,
        },
      });
      Ext.applyIf(me, {
        store: store,
        bbar: Ext.create('Ext.PagingToolbar', {
          store: store,
          displayInfo: true,
          inputItemWidth: 35,
        }),
      });

      me.callParent(arguments);
    },

    viewConfig: {
      enableTextSelection: true,
      listeners: {
        refresh: function (dataview) {
          Ext.each(dataview.panel.columns, function (column) {
            column.autoSize();
            const newWidth = Math.min(column.getWidth() + 1, 300);
            column.setWidth(newWidth);
          });
        },
      },
    },
  });
})(Ext4);
