(function (Ext) {
  Ext.define('Favourites.model.Favourite', {
    extend: 'Ext.data.Model',

    fields: [
      { name: 'id', type: 'int', useNull: true },
      { name: 'set', type: 'int' },
      { name: 'name' },
      { name: 'type' },
      {
        name: 'parameter',
        type: 'auto',
        serialize: function (value, record) {
          if (Ext.isObject(value)) {
            return value.value;
          }
          return value;
        },
      },
      {
        name: 'description',
        convert: function (value, record) {
          var parameter = record.get('parameter');
          if (parameter && parameter.renderable && parameter.value) {
            return parameter.value;
          }
          if (!value) {
            return parameter ? parameter.value : '';
          }
          return value;
        },
      },
      {
        name: 'typeDescription',
        convert: function (value, record) {
          if (!value) {
            return record.get('type');
          }
          return value;
        },
      },
      { name: 'position', type: 'int' },
      { name: 'counted', type: 'boolean' },
      { name: 'displayNameMode', type: 'string' },
      { name: 'newWindow', type: 'boolean' },
    ],

    belongsTo: {
      model: 'Favourites.model.FavouritesSet',
    },
  });
})(window.Ext4);
