/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.pwfl.web.jsonp.ResponseWrapper;
import com.suncode.pwfl.web.util.ErrorMsg;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JsonpCallbackFilter
implements Filter {
    private static Logger log = Logger.getLogger(JsonpCallbackFilter.class);

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)resp;
        String callback = req.getParameter("callback");
        if (StringUtils.isNotBlank((CharSequence)callback)) {
            log.info((Object)("Zapytanie JSONP. callback: " + callback));
            ServletOutputStream out = httpResponse.getOutputStream();
            ResponseWrapper wrapper = new ResponseWrapper(httpResponse);
            chain.doFilter(req, (ServletResponse)wrapper);
            out.write(new String(callback + "(").getBytes());
            if (wrapper.getStatus() != 200) {
                ErrorMsg jm = new ErrorMsg();
                jm.setErrorMsg(new String(wrapper.getData(), "UTF-8"));
                jm.setStatus(wrapper.getStatus());
                ObjectMapper om = new ObjectMapper();
                out.write(om.writeValueAsString((Object)jm).getBytes());
                wrapper.setStatus(200);
            } else {
                out.write(wrapper.getData());
            }
            out.write(new String(");").getBytes());
            wrapper.setContentType("text/javascript;charset=UTF-8");
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

