/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpsEnforcementFilter
implements Filter {
    private final List<String> excludes = Arrays.asList(".ico", "/img/", "/css/", "/services/ReleaseService/");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.REDIRECT_FROM_HTTP_TO_HTTPS).booleanValue() && !httpRequest.isSecure() && this.needsHttps(requestURI)) {
            String redirectURL = "https://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort() + requestURI;
            httpResponse.sendRedirect(redirectURL);
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean needsHttps(String uri) {
        return this.excludes.stream().noneMatch(uri::contains);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

