/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.documents.docclass;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.database.files.ExtendedDocumentData;
import com.plusmpm.util.DocsMerger.DocsMerger;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.IndexData;
import com.suncode.pwfl.administration.archive.DocumentClassProtectionService;
import com.suncode.pwfl.administration.archive.DocumentClassRightInfo;
import com.suncode.pwfl.administration.archive.DocumentClassRightType;
import com.suncode.pwfl.administration.archive.DocumentRightType;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.documentclass.mapper.DocumentClassSearchModelMapper;
import com.suncode.pwfl.archive.documentclass.model.DocumentClassSearchModel;
import com.suncode.pwfl.archive.documentclass.model.DocumentSearchVariableSearchModel;
import com.suncode.pwfl.archive.documentclass.service.DocumentClassSearchService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"documents/class/search"})
@Api(hidden=true)
public class DocumentClassSearchController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassSearchController.class);
    private final AuthorizationHelper authorizationHelper;
    private final DocumentClassSearchService documentClassSearchService;
    private final DocumentClassSearchModelMapper documentClassSearchModelMapper;
    private final FileService fileService;
    private final MessageHelperBean messageHelper;
    private final Map<UUID, List<Long>> exportCache = new HashMap<UUID, List<Long>>();
    private final Map<UUID, List<ExportColumn>> exportColumnsCache = new HashMap<UUID, List<ExportColumn>>();
    private final String rightLevelPattern = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)"%d").custom((Object)"%s").build();
    private final ExportService exportService;
    private final DocumentClassService documentClassService;
    private final DocumentClassProtectionService documentClassProtectionService;
    private final UserService userService;

    @PostMapping(value={"{docClassId}/results"})
    public CountedResult<ExtendedDocumentData> searchDocumentsFromClass(HttpServletRequest request, @PathVariable Long docClassId, @RequestBody DocumentClassSearchModel documentClassSearchModel, @RequestParam(name="start", required=false) Long start, @RequestParam(name="limit", required=false) Long limit, @RequestParam(name="orderBy", required=false, defaultValue="0") Long orderBy, @RequestParam(name="orderDirection", required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullRights(String.format(this.rightLevelPattern, docClassId, DocumentClassRightType.READ.getSubPath()), () -> {});
        LinkedHashMap<String, Long> auditParams = new LinkedHashMap<String, Long>();
        auditParams.put("lines[0].varValue", docClassId);
        auditParams.putAll(this.documentClassSearchModelMapper.getIndexFiltersAsMap(docClassId, documentClassSearchModel.indexFilters()));
        auditParams.putAll(this.documentClassSearchModelMapper.getAuthorFilters(documentClassSearchModel.owner()));
        auditParams.putAll(this.documentClassSearchModelMapper.getDateFilters(documentClassSearchModel.addToArchiveDate()));
        auditParams.putAll(this.documentClassSearchModelMapper.getAdditionalFilters(documentClassSearchModel.additionalFilters()));
        auditParams.entrySet().removeIf(entry -> entry.getValue() == null || entry.getValue() instanceof String && ((String)entry.getValue()).isEmpty());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_DOCCLASS).params(auditParams);
        try {
            CountedResult result = this.documentClassSearchService.search(docClassId, documentClassSearchModel, start, limit, orderBy, Long.valueOf("DESC".equals(orderDirection.name()) ? 1L : 2L));
            auditBuilder.buildSuccess(request);
            return result;
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @PostMapping(value={"{docClassId}/results/delete"})
    public RestResult deleteSearchedDocumentsFromClass(@PathVariable Long docClassId, @RequestBody DocumentClassSearchModel documentClassSearchModel) {
        this.authorizationHelper.assertFullRights(String.format(this.rightLevelPattern, docClassId, DocumentClassRightType.DELETE.getSubPath()), () -> {});
        List documentData = this.documentClassSearchService.search(docClassId, documentClassSearchModel, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L)).getData();
        documentData.sort(Comparator.comparing(o -> o.getFileVersions().getVersion()));
        String userName = SessionUtils.getLoggedUserName();
        Set userGroups = this.userService.getUser(userName, new String[]{"groups"}).getGroups();
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)docClassId);
        List documentClassProtections = this.documentClassProtectionService.getDocumentClassRights(docClassId);
        List<String> documentsWithoutRightsToDelete = this.getDocumentsWithoutRightsToDeleteForUser(documentData, documentClass, documentClassProtections, userName, userGroups);
        if (documentsWithoutRightsToDelete.size() > 0) {
            return new RestResult(false, this.messageHelper.getMessage("documents_delete_no_rights") + ": " + documentsWithoutRightsToDelete.stream().collect(Collectors.joining(", ")));
        }
        long deletedCount = 0L;
        for (ExtendedDocumentData document : documentData) {
            try {
                this.fileService.deleteFile(Long.valueOf(document.getLFileId()));
                ++deletedCount;
            }
            catch (Exception exception) {}
        }
        return new RestResult(true, this.messageHelper.getMessage("Znalezione_dokumenty_zostaly_usuniete") + ". " + this.messageHelper.getMessage("Liczba_usunietych_dokumentow") + ": " + deletedCount);
    }

    private List<String> getDocumentsWithoutRightsToDeleteForUser(List<ExtendedDocumentData> documentData, DocumentClass documentClass, List<DocumentClassRightInfo> documentClassProtections, String userName, Set<UserGroup> userGroups) {
        ArrayList<String> documentsWithoutRightsToDelete = new ArrayList<String>();
        for (ExtendedDocumentData document : documentData) {
            DocumentRightType right = this.documentClassProtectionService.getDocumentRightForUser(documentClass, documentClassProtections, Long.valueOf(document.getLFileId()), userName, userGroups);
            if (right == DocumentRightType.DELETE) continue;
            documentsWithoutRightsToDelete.add(document.getOrg_name());
        }
        return documentsWithoutRightsToDelete;
    }

    @PostMapping(value={"{docClassId}/results/print"})
    public URI printSearchedDocumentsFromClass(HttpServletRequest request, @PathVariable Long docClassId, @RequestBody DocumentClassSearchModel documentClassSearchModel, @RequestParam(name="orderBy", required=false, defaultValue="0") Long orderBy, @RequestParam(name="orderDirection", required=false, defaultValue="ASC") SortDirection orderDirection) {
        UUID id;
        this.authorizationHelper.assertFullRights(String.format(this.rightLevelPattern, docClassId, DocumentClassRightType.PRINTING.getSubPath()), () -> {});
        List documentData = this.documentClassSearchService.search(docClassId, documentClassSearchModel, Long.valueOf(0L), Long.valueOf(0L), orderBy, Long.valueOf("DESC".equals(orderDirection.name()) ? 1L : 2L)).getData();
        LinkedList<Long> filesToConvert = new LinkedList<Long>();
        for (ExtendedDocumentData document : documentData) {
            filesToConvert.add(document.getLFileId());
        }
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, filesToConvert);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    @GetMapping(value={"{docClassId}/results/print"})
    public void printSearchedDocumentsFromClass(HttpServletResponse response, @RequestParam UUID id, @PathVariable Long docClassId) throws IOException {
        this.authorizationHelper.assertFullRights(String.format(this.rightLevelPattern, docClassId, DocumentClassRightType.PRINTING.getSubPath()), () -> {});
        List<Long> filesToConvert = this.exportCache.get(id);
        this.exportCache.remove(id);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"Documents.pdf\"");
        try {
            DocsMerger.merge(filesToConvert, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.info("Wyst\u0105pi\u0142 b\u0142\u0105d podczas \u0142\u0105czenia dokument\u00f3w");
        }
    }

    @PostMapping(value={"{docClassId}/results/export/{extension}"})
    public URI exportDocumentsFromClass(HttpServletRequest request, @PathVariable Long docClassId, @RequestBody DocumentClassSearchModel documentClassSearchModel, @PathVariable String extension, @RequestParam(name="orderBy", required=false, defaultValue="0") Long orderBy, @RequestParam(name="orderDirection", required=false, defaultValue="ASC") SortDirection orderDirection) {
        Queue columnOrder = documentClassSearchModel.indexFilters().stream().map(DocumentSearchVariableSearchModel::id).collect(Collectors.toCollection(LinkedList::new));
        List documentData = this.documentClassSearchService.search(docClassId, documentClassSearchModel, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), orderBy, Long.valueOf("DESC".equals(orderDirection.name()) ? 1L : 2L)).getData();
        Map dateFilters = this.documentClassSearchModelMapper.getDateFilters(documentClassSearchModel.addToArchiveDate());
        Map ownerFilters = this.documentClassSearchModelMapper.getAuthorFilters(documentClassSearchModel.owner());
        List<Map<Long, String>> indexData = this.getIndexData(documentData);
        List<ExportColumn> columns = this.prepareColumns(documentData, indexData, columnOrder, dateFilters, ownerFilters, documentClassSearchModel.additionalFilters());
        return this.getRedirectUri(request, columns);
    }

    @GetMapping(value={"{docClassId}/results/export/{extension}"})
    public void exportDocumentsFromClass(HttpServletResponse response, @PathVariable Long docClassId, @PathVariable String extension, @RequestParam UUID id) throws IOException {
        this.exportDocuments(this.getCachedColumns(id), response, extension);
    }

    private List<Map<Long, String>> getIndexData(List<ExtendedDocumentData> documentData) {
        if (documentData.isEmpty()) {
            throw new ServiceException(this.messageHelper.getMessage("Brak_dokumentow_do_eksportu"));
        }
        return documentData.stream().map(list -> list.getAlIndecies().stream().collect(Collectors.toMap(IndexData::getId, IndexData::getValue))).toList();
    }

    private URI getRedirectUri(HttpServletRequest request, List<ExportColumn> columns) {
        UUID id;
        while (this.exportColumnsCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportColumnsCache.put(id, columns);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<ExportColumn> getCachedColumns(UUID id) {
        List<ExportColumn> columns = this.exportColumnsCache.get(id);
        this.exportColumnsCache.remove(id);
        return columns;
    }

    private List<ExportColumn> prepareColumns(List<ExtendedDocumentData> documentData, List<Map<Long, String>> indexData, Queue<String> columnOrder, Map<String, Object> dateFilters, Map<String, Object> ownerFilters, List<DocumentSearchVariableSearchModel> additionalFilters) {
        LinkedList<ExportColumn> columns = new LinkedList<ExportColumn>();
        if (!indexData.isEmpty()) {
            Map<Long, String> firstRow = indexData.get(0);
            while (!columnOrder.isEmpty()) {
                String indexId = columnOrder.poll();
                if (!firstRow.containsKey(Long.parseLong(indexId))) continue;
                columns.add(this.buildExportColumn(this.documentClassService.getDocumentClassIndexTranslation(Long.valueOf(Long.parseLong(indexId)), TranslatedFieldType.NAME), indexData, indices -> (String)indices.get(Long.parseLong(indexId))));
            }
        }
        if (BooleanUtils.toBoolean((String)((String)dateFilters.get("showDate")), (String)"on", (String)"")) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Data_dokumentu"), documentData, DocumentData::getSDocumentDate));
        }
        if (BooleanUtils.toBoolean((String)((String)ownerFilters.get("showAuthor")), (String)"on", (String)"")) {
            columns.add(this.buildExportColumn(this.messageHelper.getMessage("Wlasciciel"), documentData, ExtendedDocumentData::getOwner));
        }
        additionalFilters.stream().filter(filter -> filter.value().getExtraValueSearchModel().isShowColumn()).filter(filter -> !filter.id().equals("showAllVersions")).forEach(filter -> columns.add(this.buildExportColumn(filter.name(), documentData, this.getAdditionalFilterSupplier(filter.id()))));
        return columns;
    }

    private Function<ExtendedDocumentData, String> getAdditionalFilterSupplier(String id) {
        return switch (id) {
            case "version" -> extendedDocumentData -> extendedDocumentData.getFileVersions().getVersion().toString();
            case "documentState" -> ExtendedDocumentData::getState;
            case "checkoutDate" -> extendedDocumentData -> this.convertDateToString(extendedDocumentData.getFileVersions().getCheckout_date());
            case "checkOutUser" -> extendedDocumentData -> extendedDocumentData.getFileVersions().getCheckout_user();
            case "comment" -> extendedDocumentData -> extendedDocumentData.getFileVersions().getComment();
            case "orgFileName" -> ExtendedDocumentData::getOrg_name;
            case "attachedStatus" -> ExtendedDocumentData::getAttached_status;
            default -> throw new IllegalStateException("Unexpected value: " + id);
        };
    }

    private String convertDateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format((Object)date);
    }

    private void exportDocuments(List<ExportColumn> columns, HttpServletResponse response, String extension) throws IOException {
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Dokumenty")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private <T> ExportColumn buildExportColumn(String name, List<T> data, Function<T, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @ConstructorProperties(value={"authorizationHelper", "documentClassSearchService", "documentClassSearchModelMapper", "fileService", "messageHelper", "exportService", "documentClassService", "documentClassProtectionService", "userService"})
    @Autowired
    public DocumentClassSearchController(AuthorizationHelper authorizationHelper, DocumentClassSearchService documentClassSearchService, DocumentClassSearchModelMapper documentClassSearchModelMapper, FileService fileService, MessageHelperBean messageHelper, ExportService exportService, DocumentClassService documentClassService, DocumentClassProtectionService documentClassProtectionService, UserService userService) {
        this.authorizationHelper = authorizationHelper;
        this.documentClassSearchService = documentClassSearchService;
        this.documentClassSearchModelMapper = documentClassSearchModelMapper;
        this.fileService = fileService;
        this.messageHelper = messageHelper;
        this.exportService = exportService;
        this.documentClassService = documentClassService;
        this.documentClassProtectionService = documentClassProtectionService;
        this.userService = userService;
    }
}

