/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.datasource;

import com.suncode.pwfl.datasource.DataSourceCategoryDto;
import com.suncode.pwfl.datasource.DataSourceCategoryService;
import com.suncode.pwfl.datasource.dao.DataSourceCategory;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datasource/category"})
public class DataSourceCategoryController {
    @Autowired
    private DataSourceCategoryService dataSourceCategoryService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"/"})
    @ResponseBody
    private List<DataSourceCategoryDto> getCategories() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.dataSourceCategoryService.getAll(new String[0]).stream().map(DataSourceCategoryDto::new).collect(Collectors.toList());
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    private Long createCategory(@RequestParam String name) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DataSourceCategory dataSourceCategory = this.dataSourceCategoryService.getOrCreate(name);
        return dataSourceCategory.getId();
    }
}

