/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.TransactionException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.springframework.context.i18n.LocaleContextHolder;

public class GetProcessAssignmentsServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(GetProcessAssignmentsServlet.class);
    private static final long serialVersionUID = -5810595335443215306L;

    private static String getAssigneesRealNames(SharkTransaction sharkTransaction, WfAssignment[] wfAssignments) throws BaseException, TransactionException {
        UserGroupAdministration userGroupAdministration = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        StringBuilder assignees = new StringBuilder(0);
        UserTransaction userTransaction = null;
        try {
            userTransaction = Shark.getInstance().createUserTransaction();
            for (WfAssignment wfAssignment : wfAssignments) {
                String userName = wfAssignment.assignee(sharkTransaction).resource_key(sharkTransaction);
                assignees.append(userGroupAdministration.getUserRealName(userTransaction, userName));
                assignees.append(", ");
            }
            userTransaction.commit();
        }
        catch (TransactionException te) {
            GetProcessAssignmentsServlet.rollbackUserTransaction(userTransaction);
            throw te;
        }
        catch (BaseException be) {
            GetProcessAssignmentsServlet.rollbackUserTransaction(userTransaction);
            throw be;
        }
        finally {
            GetProcessAssignmentsServlet.releaseUserTransaction(userTransaction);
        }
        if (assignees.length() > 1) {
            assignees = assignees.delete(assignees.length() - 2, assignees.length());
        }
        return assignees.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Map<String, String>> getJsonRecords(String processId) {
        SharkTransaction sharkTransaction = null;
        try {
            sharkTransaction = Shark.getInstance().createTransaction();
            sharkTransaction.setReadOnly(true);
            Map wfAssignmentsMap = SharkFunctions.getWfAssignments((SharkTransaction)sharkTransaction, (String)processId, (String[])new String[]{"open.running", "open.not_running.suspended", "open.not_running.not_started"});
            String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)sharkTransaction, (String)processId);
            String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefId);
            I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
            ArrayList result = new ArrayList(wfAssignmentsMap.size());
            int id = 0;
            for (String activityId : wfAssignmentsMap.keySet()) {
                WfAssignment[] wfAssignments = (WfAssignment[])wfAssignmentsMap.get(activityId);
                WfActivity wfActivity = wfAssignments[0].activity(sharkTransaction);
                String realProcessId = wfActivity.container(sharkTransaction).key(sharkTransaction);
                String realProcessDefId = SharkFunctions.getProcessDefId((SharkTransaction)sharkTransaction, (String)realProcessId);
                String activityDefId = SharkFunctions.getActivityDefId((SharkTransaction)sharkTransaction, (String)realProcessId, (String)activityId);
                HashMap<String, String> jsonRecord = new HashMap<String, String>();
                jsonRecord.put("id", String.valueOf(id++));
                jsonRecord.put("activityId", activityId);
                jsonRecord.put("activityName", xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(realProcessDefId).forActivity(activityDefId).getKey()));
                jsonRecord.put("assignDate", String.valueOf(wfActivity.last_state_time(sharkTransaction).getTime()));
                jsonRecord.put("assigned", String.valueOf(wfAssignments[0].get_accepted_status(sharkTransaction)));
                jsonRecord.put("assignees", GetProcessAssignmentsServlet.getAssigneesRealNames(sharkTransaction, wfAssignments));
                result.add(jsonRecord);
            }
            sharkTransaction.commit();
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable.getMessage(), throwable);
            try {
                Shark.getInstance().emptyCaches(sharkTransaction);
            }
            catch (Exception e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                sharkTransaction.rollback();
            }
            catch (Exception e2) {
                LOG.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        finally {
            try {
                Shark.getInstance().unlockProcesses(sharkTransaction);
            }
            catch (Exception e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                sharkTransaction.release();
            }
            catch (Exception e3) {
                LOG.error((Object)e3.getMessage(), (Throwable)e3);
            }
        }
        return Collections.emptyList();
    }

    private static void releaseUserTransaction(UserTransaction userTransaction) {
        try {
            userTransaction.release();
        }
        catch (TransactionException te) {
            LOG.error((Object)te.getMessage(), (Throwable)te);
        }
    }

    private static void rollbackUserTransaction(UserTransaction userTransaction) {
        try {
            userTransaction.rollback();
        }
        catch (TransactionException te) {
            LOG.error((Object)te.getMessage(), (Throwable)te);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.trace((Object)"****************************** GetActivityStatusesHistoryServlet.doGet ******************************");
        super.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOG.trace((Object)"****************************** GetActivityStatusesHistoryServlet.doPost ******************************");
        try (PrintWriter printWriter = null;){
            String processId = req.getParameter("processId");
            JsonStore jsonStore = new JsonStore();
            jsonStore.setRecords(GetProcessAssignmentsServlet.getJsonRecords(processId));
            GsonCustomUtils gsonCustomUtils = new GsonCustomUtils();
            String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            printWriter = resp.getWriter();
            printWriter.print(sJsonData);
        }
    }
}

