(function(Ext, messages) {

	Ext.define('Suncode.pluginmanager.view.PluginDetails', {
		extend : 'Ext.form.Panel',
		requires: ['Suncode.pluginmanager.view.UpdateForm'],
		alias : 'widget.pluginmanager-details',

		layout: 'form',
		frame: true,
		initComponent : function() {

	        Ext.apply(this, {
	            items: [{
					xtype: 'fieldset',
					title: messages('view.details.attributes'),
					defaultType: 'displayfield',
					collapsible: true,
					style: 'width: 100%',
					items: [{
						name: 'name',
						fieldLabel: messages('plugin.name'),
					}, {
						name: 'version',
						fieldLabel: messages('plugin.version')
					}, {
						name: 'key',
						fieldLabel: messages('plugin.key')
					}, {
						name: 'description',
						fieldLabel: messages('plugin.description')
					}, {
						name: 'author',
						fieldLabel: messages('plugin.author')
					}, {
						name: 'license',
						fieldLabel: messages('plugins.view.information.license')
					}, {
						name: 'updated',
						fieldLabel: messages('plugin.lastupdate'),
						renderer: function(value){
					        return Ext.util.Format.date(value, 'Y-m-d H:i:s');
					    }
					}]
				}, {
					xtype: 'displayfield',
					fieldLabel: messages('plugin.state'),
				    name: 'running',
				    renderer: function(active, field){
				        var status = messages('plugin.state.stopped'),
				            css = 'failure-status dvnt-icon-x-symbol dvnt-red-icon';

				        if(active == true){
				        	status = messages('plugin.state.active');
				        	css = 'success-status dvnt-icon-check-symbol dvnt-green-icon';
				        }
				        return String.format('<span class="{0}" style="padding-left:25px">{1}</span>', css, status);
				    }
				}, {
				    xtype: 'container',
				    layout: 'column',
				    defaults: {
					    xtype: 'button',
					    columnWidth: .25,
					    padding: 3,
					    margin: '0 2'
					},
				    items: [{
				        text: messages('start'),
				        itemId: 'runPlugin',
				        iconCls: 'dvnt-icon-right',
				        handler: this.startPlugin,
				        scope: this
				    },{
				    	text: messages('stop'),
				    	itemId: 'stopPlugin',
				    	disabled: true,
				        iconCls: 'dvnt-icon-stop-symbol',
				        handler: this.stopPlugin,
				        scope: this
				    },{
			    	    text: messages('update'),
			    	    itemId: 'updatePlugin',
			    	    iconCls: 'dvnt-icon-edit-form',
			    	    handler: this.updatePlugin,
			    	    scope: this
				    },{
				    	text: messages('delete'),
				        iconCls: 'dvnt-icon-delete',
				        handler: this.deletePlugin,
				        scope: this
				    }]
				}]
	        });

			this.callParent();

			this.actionMask = new Ext.LoadMask({target: this});
	        this.runPluginBtn = this.down('button#runPlugin');
	        this.stopPluginBtn = this.down('button#stopPlugin');
	        this.updatePluginBtn = this.down('button#updatePlugin');

	        this.initPluginUpdateDialog();
		},

		bind: function(plugin){
			var me = this;

			me.initStoreListener(plugin.store);
			me.updateForm(plugin);

			me.show();
		},

		initStoreListener: function(store){
		    var me = this;

		    if(me.storeListener){
		    	return;
	    	}

		    me.storeListener = store.on('datachanged', function(store){
		        var currentPlugin = me.getRecord(),
		            updatedPlugin;

                if(currentPlugin){
                    updatedPlugin = store.getById(currentPlugin.getId());
                    if(updatedPlugin){
                        me.updateForm(updatedPlugin);
                    }
                }
		    }, me, {destroyable: true});
		},

		updateForm: function(plugin){
		    var me = this;

	        me.loadRecord(plugin);

		    // tytuł
		    me.setTitle(messages('view.details.title', plugin.get('name')));

			// przyciski
			me.runPluginBtn.setDisabled(plugin.isRunning());
			me.stopPluginBtn.setDisabled(!plugin.isRunning());
		},

		startPlugin: function(){
		    this.fireEvent('start', this.getRecord());
		},

		stopPlugin: function(){
		    this.fireEvent('stop', this.getRecord());
		},

		updatePlugin: function(){
		    var me = this;
	        me.dialog.update(me.getRecord());
		},

		deletePlugin: function(){
		    var me = this,
		        plugin = this.getRecord(),
		        title = messages('view.details.delete.confirm.title', plugin.get('name')),
		        msg = messages('view.details.delete.confirm.msg', Ext.String.format('{0} ({1})', plugin.get('name'), plugin.get('key')));

		    Ext.MessageBox.confirm(title, msg, function(buttonId){
		    	if(buttonId == 'yes'){
		    	    me.fireEvent('uninstall', plugin);
		    	}
		    });
		},

		initPluginUpdateDialog: function(){
		    var me = this;
		    me.dialog = Ext.widget('pluginmanager-updater', {
		        alignComponent: me.updatePluginBtn,
		        alignType: 'b-t'
	        });
		},

		mask: function(msg){
		    var mask = this.actionMask;
		    mask.msg = msg;
		    mask.show();
		},

		unmask: function(msg){
			var mask = this.actionMask;
		    mask.hide();
		},

		onDestroy: function(){
		    this.callParent();
		    Ext.destroy(this.actionMask);
		    Ext.destroy(this.dialog);

		    if(this.storeListener){
		        this.storeListener.destroy();
		    }
		}
	});

}(Ext4, Suncode.pluginmanager.i18n.MessageSource.getMessage));
