Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

Ext.ux.plusmpm.scheduledtasks.DatetimeField = function (config) {
  var me = this;

  var paramData = config.paramData;

  var passedListeners = config.listeners;

  Ext.apply(config, {
    xtype: 'datefield',
    ref: 'input',

    format: 'Y-m-d H:i:s',
    flex: 1,

    triggerClass: 'dvnt-icon-time',
    invalidClass: 'avoid-border-non-existent-class',
    onTriggerClick: function () {},

    listeners: {
      afterrender: function (field) {
        field.trigger.on('mouseover', function () {
          var x = field.trigger.getX();
          var y = field.trigger.getY();

          Calendar.setup({
            inputField: me.id,
            ifFormat: '%Y-%m-%d %H:%M:%S',
            button: field.trigger.id,
            singleClick: true,
            showsTime: true,
            timeFormat: '24',
            position: [x + 70, y],
            onUpdate: function (cal) {
              me.validate();
            },
          });

          var triggerRawEl = field.trigger.dom;
          var clickFunc = triggerRawEl.onclick;
          triggerRawEl.onclick = function () {
            if (!me.disabled && !me.readOnly) {
              clickFunc();
            }
          };
        });
      },

      invalid: function (field) {
        field.wrap.addClass('x-form-invalid');
      },

      valid: function (field) {
        field.wrap.removeClass('x-form-invalid');
      },
    },
  });
  Ext.apply(config, paramData.valueInfo);
  Ext.apply(config, paramData.fieldInfo);

  config.listeners = PW.ScheduledTaskUtils.getMergedListeners(passedListeners, config.listeners);

  Ext.ux.plusmpm.scheduledtasks.DatetimeField.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.DatetimeField, Ext.form.DateField, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.DatetimeField.superclass.initComponent.call(this);
  },

  setRequired: function (isRequired) {
    this.allowBlank = !isRequired;
  },
});

Ext.reg('st_datetimefield', Ext.ux.plusmpm.scheduledtasks.DatetimeField);
