/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.suncode.plugin.framework.PluginsException;
import com.suncode.plugin.framework.config.ModuleDefinition;
import com.suncode.plugin.framework.support.module.ModuleHelper;
import com.suncode.plugin.framework.support.module.ModuleSupport;
import com.suncode.pwfl.web.ui.ScriptInjection;
import com.suncode.pwfl.web.ui.WebScripts;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebScriptsModule
extends ModuleSupport<Void> {
    public static final String NAME = "web-scripts";
    @Autowired
    private WebScripts webScripts;
    private String fragment;
    private Set<String> resources = Sets.newHashSet();
    private List<ScriptInjection> scripts = Lists.newArrayList();

    protected void initModule() throws PluginsException {
        ModuleDefinition module = this.getDefinition();
        this.fragment = ModuleHelper.getAttribute((String)"fragment", (ModuleDefinition)module);
        this.resources.addAll(this.readResources(module));
        if (this.resources.isEmpty()) {
            throw new PluginsException("No \"resource\" attribute or <resource> elements specified");
        }
    }

    public void enable() throws PluginsException {
        for (String resourceLocation : this.resources) {
            Resource resource = this.getPlugin().getResource(resourceLocation);
            if (!resource.exists()) {
                throw new PluginsException("Resource [" + String.valueOf(resource) + "] does not exists");
            }
            this.scripts.add(this.webScripts.inject(this.fragment, resource));
        }
        super.enable();
    }

    public void disable() throws PluginsException {
        for (ScriptInjection script : this.scripts) {
            script.remove();
        }
        super.disable();
    }

    private Set<String> readResources(ModuleDefinition module) {
        HashSet resources = Sets.newHashSet();
        String resource = ModuleHelper.getAttribute((String)"resource", (ModuleDefinition)module, (boolean)true);
        if (StringUtils.hasText((String)resource)) {
            resources.add(resource);
        }
        Element root = module.getElement();
        NodeList resourcesNodes = root.getElementsByTagName("resource");
        for (int i = 0; i < resourcesNodes.getLength(); ++i) {
            Element resourceNode = (Element)resourcesNodes.item(i);
            resource = resourceNode.getTextContent();
            if (!StringUtils.hasText((String)resource)) continue;
            resources.add(resource);
        }
        return resources;
    }
}

