/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.administration.user.User;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Component;

@Component
public class UserCriteriaHelper {
    public DetachedCriteria createQueryCriteria(String query, String firstNameQuery, String lastNameQuery) {
        boolean firstOrLastNameQueryNull;
        boolean bl = firstOrLastNameQueryNull = firstNameQuery == null || lastNameQuery == null;
        if (firstOrLastNameQueryNull) {
            return this.createOrCriteria(query);
        }
        return this.createAndCriteria(query, firstNameQuery, lastNameQuery);
    }

    private DetachedCriteria createOrCriteria(String query) {
        DetachedCriteria criteria = DetachedCriteria.forClass(User.class);
        if (StringUtils.isNotBlank((String)query)) {
            Disjunction or = Restrictions.disjunction();
            List<String> queryWords = Arrays.stream(query.split(" ")).toList();
            or.add(Restrictions.ilike((String)"userName", (String)query, (MatchMode)MatchMode.ANYWHERE));
            for (String queryWord : queryWords) {
                or.add(Restrictions.ilike((String)"firstName", (String)queryWord, (MatchMode)MatchMode.ANYWHERE));
                or.add(Restrictions.ilike((String)"lastName", (String)queryWord, (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)or);
        }
        return criteria;
    }

    private DetachedCriteria createAndCriteria(String query, String firstNameQuery, String lastNameQuery) {
        DetachedCriteria criteria = DetachedCriteria.forClass(User.class);
        Conjunction and = Restrictions.conjunction();
        if (StringUtils.isNotBlank((String)query)) {
            and.add(Restrictions.ilike((String)"userName", (String)query, (MatchMode)MatchMode.ANYWHERE));
        }
        if (StringUtils.isNotBlank((String)firstNameQuery)) {
            and.add(Restrictions.ilike((String)"firstName", (String)firstNameQuery, (MatchMode)MatchMode.ANYWHERE));
        }
        if (StringUtils.isNotBlank((String)lastNameQuery)) {
            and.add(Restrictions.ilike((String)"lastName", (String)lastNameQuery, (MatchMode)MatchMode.ANYWHERE));
        }
        criteria.add((Criterion)and);
        return criteria;
    }
}

