/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.archive.AddDirectoryDto;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.web.dto.archive.DirectoryDto;
import com.suncode.pwfl.web.dto.archive.RootDirectoryDto;
import com.suncode.pwfl.web.support.DeviceMapper;
import java.beans.ConstructorProperties;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DirectoryMapper {
    private final ArchiveStorageService archiveStorageService;
    private final DeviceMapper deviceMapper;

    public Directory fromDto(AddDirectoryDto dto) {
        Directory rootDirectory = dto.getRootDirectoryId() != null ? this.archiveStorageService.getDirectory(dto.getRootDirectoryId(), new String[0]) : null;
        Device device = this.archiveStorageService.getDeviceById(dto.getDeviceId(), new String[0]);
        return Directory.builder().directoryName(dto.getName()).directorySize(dto.getSize()).directoryThreshold(dto.getThreshold()).rootDir(rootDirectory).device(device).build();
    }

    public DirectoryDto fromEntity(Directory directory, boolean escapeHTML) {
        if (directory == null) {
            return null;
        }
        DirectoryDto build = DirectoryDto.builder().id(directory.getId()).rootDir(RootDirectoryDto.fromEntity(directory.getRootDir())).device(this.deviceMapper.fromEntity(directory.getDevice())).directoryName(directory.getDirectoryName()).directorySize(directory.getDirectorySize()).directoryThreshold(directory.getDirectoryThreshold()).directoryFreeSpace(directory.getDirectoryFreeSpace()).build();
        if (escapeHTML) {
            build.setDirectoryName(StringEscapeUtils.escapeHtml((String)directory.getDirectoryName()));
        }
        return build;
    }

    public DirectoryDto fromEntity(Directory directory) {
        return this.fromEntity(directory, true);
    }

    @ConstructorProperties(value={"archiveStorageService", "deviceMapper"})
    @Autowired
    public DirectoryMapper(ArchiveStorageService archiveStorageService, DeviceMapper deviceMapper) {
        this.archiveStorageService = archiveStorageService;
        this.deviceMapper = deviceMapper;
    }
}

