/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.favourites;

import com.suncode.pwfl.favourites.FavouriteElement;
import com.suncode.pwfl.favourites.view.FavouritesRenderer;
import com.suncode.pwfl.web.dto.favourites.FavouritesElementDto;
import com.suncode.pwfl.web.ui.DivanteColor;
import com.suncode.pwfl.web.ui.DivanteIcon;
import java.beans.ConstructorProperties;
import java.util.Objects;

public class FavouritesRowDto {
    private String name;
    private String type;
    private String description;
    private String icon;
    private String tileColor;
    private String action;
    private FavouritesElementDto favouritesElementDto;

    public FavouritesRowDto(FavouriteElement favouriteElement, FavouritesRenderer renderer) {
        this.name = renderer.renderName();
        this.type = renderer.renderType();
        this.description = renderer.renderDescription();
        this.icon = Objects.isNull(renderer.renderIcon()) ? DivanteIcon.STAR.getCode() : renderer.renderIcon();
        this.tileColor = Objects.isNull(renderer.renderTileColor()) ? DivanteColor.BLUE.getCode() : renderer.renderTileColor();
        this.action = renderer.renderAction();
        this.favouritesElementDto = new FavouritesElementDto(favouriteElement);
    }

    public static FavouritesRowDtoBuilder builder() {
        return new FavouritesRowDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getTileColor() {
        return this.tileColor;
    }

    public String getAction() {
        return this.action;
    }

    public FavouritesElementDto getFavouritesElementDto() {
        return this.favouritesElementDto;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setTileColor(String tileColor) {
        this.tileColor = tileColor;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFavouritesElementDto(FavouritesElementDto favouritesElementDto) {
        this.favouritesElementDto = favouritesElementDto;
    }

    public FavouritesRowDto() {
    }

    @ConstructorProperties(value={"name", "type", "description", "icon", "tileColor", "action", "favouritesElementDto"})
    public FavouritesRowDto(String name, String type, String description, String icon, String tileColor, String action, FavouritesElementDto favouritesElementDto) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.icon = icon;
        this.tileColor = tileColor;
        this.action = action;
        this.favouritesElementDto = favouritesElementDto;
    }

    public static class FavouritesRowDtoBuilder {
        private String name;
        private String type;
        private String description;
        private String icon;
        private String tileColor;
        private String action;
        private FavouritesElementDto favouritesElementDto;

        FavouritesRowDtoBuilder() {
        }

        public FavouritesRowDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FavouritesRowDtoBuilder type(String type) {
            this.type = type;
            return this;
        }

        public FavouritesRowDtoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FavouritesRowDtoBuilder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public FavouritesRowDtoBuilder tileColor(String tileColor) {
            this.tileColor = tileColor;
            return this;
        }

        public FavouritesRowDtoBuilder action(String action) {
            this.action = action;
            return this;
        }

        public FavouritesRowDtoBuilder favouritesElementDto(FavouritesElementDto favouritesElementDto) {
            this.favouritesElementDto = favouritesElementDto;
            return this;
        }

        public FavouritesRowDto build() {
            return new FavouritesRowDto(this.name, this.type, this.description, this.icon, this.tileColor, this.action, this.favouritesElementDto);
        }

        public String toString() {
            return "FavouritesRowDto.FavouritesRowDtoBuilder(name=" + this.name + ", type=" + this.type + ", description=" + this.description + ", icon=" + this.icon + ", tileColor=" + this.tileColor + ", action=" + this.action + ", favouritesElementDto=" + String.valueOf(this.favouritesElementDto) + ")";
        }
    }
}

