/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.archive.CipherMode;
import java.beans.ConstructorProperties;

public final class CipherModeDto {
    private final String name;
    private final String description;
    private final boolean requiresIV;

    public static CipherModeDto from(CipherMode cipherMode) {
        return CipherModeDto.builder().name(cipherMode.name()).description(cipherMode.getDescription()).requiresIV(cipherMode.isRequiresIV()).build();
    }

    @ConstructorProperties(value={"name", "description", "requiresIV"})
    CipherModeDto(String name, String description, boolean requiresIV) {
        this.name = name;
        this.description = description;
        this.requiresIV = requiresIV;
    }

    public static CipherModeDtoBuilder builder() {
        return new CipherModeDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequiresIV() {
        return this.requiresIV;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CipherModeDto)) {
            return false;
        }
        CipherModeDto other = (CipherModeDto)o;
        if (this.isRequiresIV() != other.isRequiresIV()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequiresIV() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "CipherModeDto(name=" + this.getName() + ", description=" + this.getDescription() + ", requiresIV=" + this.isRequiresIV() + ")";
    }

    public static class CipherModeDtoBuilder {
        private String name;
        private String description;
        private boolean requiresIV;

        CipherModeDtoBuilder() {
        }

        public CipherModeDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CipherModeDtoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public CipherModeDtoBuilder requiresIV(boolean requiresIV) {
            this.requiresIV = requiresIV;
            return this;
        }

        public CipherModeDto build() {
            return new CipherModeDto(this.name, this.description, this.requiresIV);
        }

        public String toString() {
            return "CipherModeDto.CipherModeDtoBuilder(name=" + this.name + ", description=" + this.description + ", requiresIV=" + this.requiresIV + ")";
        }
    }
}

